/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.reactive;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.reactive.result.view.CsrfRequestDataValueProcessor;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.WebFilterChainProxy;
import org.springframework.util.ObjectUtils;

@Configuration
class WebFluxSecurityConfiguration {
    public static final int WEB_FILTER_CHAIN_FILTER_ORDER = -100;
    private static final String BEAN_NAME_PREFIX = "org.springframework.security.config.annotation.web.reactive.WebFluxSecurityConfiguration.";
    private static final String SPRING_SECURITY_WEBFILTERCHAINFILTER_BEAN_NAME = "org.springframework.security.config.annotation.web.reactive.WebFluxSecurityConfiguration.WebFilterChainFilter";
    @Autowired(required=false)
    private List<SecurityWebFilterChain> securityWebFilterChains;
    @Autowired
    ApplicationContext context;

    WebFluxSecurityConfiguration() {
    }

    @Bean(value={"org.springframework.security.config.annotation.web.reactive.WebFluxSecurityConfiguration.WebFilterChainFilter"})
    @Order(value=-100)
    public WebFilterChainProxy springSecurityWebFilterChainFilter() {
        return new WebFilterChainProxy(this.getSecurityWebFilterChains());
    }

    @Bean(name={"requestDataValueProcessor"})
    public CsrfRequestDataValueProcessor requestDataValueProcessor() {
        return new CsrfRequestDataValueProcessor();
    }

    private List<SecurityWebFilterChain> getSecurityWebFilterChains() {
        List<SecurityWebFilterChain> result = this.securityWebFilterChains;
        if (ObjectUtils.isEmpty(result)) {
            return Arrays.asList(this.springSecurityFilterChain());
        }
        return result;
    }

    private SecurityWebFilterChain springSecurityFilterChain() {
        ServerHttpSecurity http = (ServerHttpSecurity)this.context.getBean(ServerHttpSecurity.class);
        return this.springSecurityFilterChain(http);
    }

    private SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http) {
        http.authorizeExchange().anyExchange().authenticated().and().httpBasic().and().formLogin();
        return http.build();
    }
}

