/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.test.util.AssertionErrors;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.ModelAndView;

public abstract class ModelAndViewAssert {
    public static <T> T assertAndReturnModelAttributeOfType(ModelAndView mav, String modelName, Class<T> expectedType) {
        Map model;
        Object obj;
        if (mav == null) {
            AssertionErrors.fail("ModelAndView is null");
        }
        if ((obj = (model = mav.getModel()).get(modelName)) == null) {
            AssertionErrors.fail("Model attribute with name '" + modelName + "' is null");
        }
        AssertionErrors.assertTrue("Model attribute is not of expected type '" + expectedType.getName() + "' but rather of type '" + obj.getClass().getName() + "'", expectedType.isAssignableFrom(obj.getClass()));
        return (T)obj;
    }

    public static void assertCompareListModelAttribute(ModelAndView mav, String modelName, List expectedList) {
        AssertionErrors.assertTrue("ModelAndView is null", mav != null);
        List modelList = ModelAndViewAssert.assertAndReturnModelAttributeOfType(mav, modelName, List.class);
        AssertionErrors.assertTrue("Size of model list is '" + modelList.size() + "' while size of expected list is '" + expectedList.size() + "'", expectedList.size() == modelList.size());
        AssertionErrors.assertTrue("List in model under name '" + modelName + "' is not equal to the expected list.", expectedList.equals(modelList));
    }

    public static void assertModelAttributeAvailable(ModelAndView mav, String modelName) {
        if (mav == null) {
            AssertionErrors.fail("ModelAndView is null");
        }
        Map model = mav.getModel();
        AssertionErrors.assertTrue("Model attribute with name '" + modelName + "' is not available", model.containsKey(modelName));
    }

    public static void assertModelAttributeValue(ModelAndView mav, String modelName, Object expectedValue) {
        AssertionErrors.assertTrue("ModelAndView is null", mav != null);
        Object modelValue = ModelAndViewAssert.assertAndReturnModelAttributeOfType(mav, modelName, Object.class);
        AssertionErrors.assertTrue("Model value with name '" + modelName + "' is not the same as the expected value which was '" + expectedValue + "'", modelValue.equals(expectedValue));
    }

    public static void assertModelAttributeValues(ModelAndView mav, Map<String, Object> expectedModel) {
        StringBuilder sb;
        Map model;
        if (mav == null) {
            AssertionErrors.fail("ModelAndView is null");
        }
        if (!(model = mav.getModel()).keySet().equals(expectedModel.keySet())) {
            sb = new StringBuilder("Keyset of expected model does not match.\n");
            ModelAndViewAssert.appendNonMatchingSetsErrorMessage(expectedModel.keySet(), model.keySet(), sb);
            AssertionErrors.fail(sb.toString());
        }
        sb = new StringBuilder();
        for (String modelName : model.keySet()) {
            Object mavValue;
            Object assertionValue = expectedModel.get(modelName);
            if (assertionValue.equals(mavValue = model.get(modelName))) continue;
            sb.append("Value under name '").append(modelName).append("' differs, should have been '").append(assertionValue).append("' but was '").append(mavValue).append("'\n");
        }
        if (sb.length() != 0) {
            sb.insert(0, "Values of expected model do not match.\n");
            AssertionErrors.fail(sb.toString());
        }
    }

    public static void assertSortAndCompareListModelAttribute(ModelAndView mav, String modelName, List expectedList, Comparator comparator) {
        AssertionErrors.assertTrue("ModelAndView is null", mav != null);
        List modelList = ModelAndViewAssert.assertAndReturnModelAttributeOfType(mav, modelName, List.class);
        AssertionErrors.assertTrue("Size of model list is '" + modelList.size() + "' while size of expected list is '" + expectedList.size() + "'", expectedList.size() == modelList.size());
        if (comparator != null) {
            Collections.sort(modelList, comparator);
            Collections.sort(expectedList, comparator);
        } else {
            Collections.sort(modelList);
            Collections.sort(expectedList);
        }
        AssertionErrors.assertTrue("List in model under name '" + modelName + "' is not equal to the expected list.", expectedList.equals(modelList));
    }

    public static void assertViewName(ModelAndView mav, String expectedName) {
        if (mav == null) {
            AssertionErrors.fail("ModelAndView is null");
        }
        AssertionErrors.assertTrue("View name is not equal to '" + expectedName + "' but was '" + mav.getViewName() + "'", ObjectUtils.nullSafeEquals((Object)expectedName, (Object)mav.getViewName()));
    }

    private static void appendNonMatchingSetsErrorMessage(Set<String> assertionSet, Set<String> incorrectSet, StringBuilder sb) {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.addAll(incorrectSet);
        tempSet.removeAll(assertionSet);
        if (tempSet.size() > 0) {
            sb.append("Set has too many elements:\n");
            for (Object e : tempSet) {
                sb.append('-');
                sb.append(e);
                sb.append('\n');
            }
        }
        tempSet = new HashSet();
        tempSet.addAll(assertionSet);
        tempSet.removeAll(incorrectSet);
        if (tempSet.size() > 0) {
            sb.append("Set is missing elements:\n");
            for (Object e : tempSet) {
                sb.append('-');
                sb.append(e);
                sb.append('\n');
            }
        }
    }
}

