/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.servlet.javaee;

import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.ssssssss.magicapi.core.config.MagicAPIProperties;
import org.ssssssss.magicapi.core.interceptor.AuthorizationInterceptor;
import org.ssssssss.magicapi.core.servlet.MagicRequestContextHolder;
import org.ssssssss.magicapi.servlet.javaee.MagicJavaEECorsFilter;
import org.ssssssss.magicapi.servlet.javaee.MagicJavaEEHttpServletRequest;
import org.ssssssss.magicapi.servlet.javaee.MagicJavaEEHttpServletResponse;
import org.ssssssss.magicapi.servlet.javaee.MagicJavaEERequestContextHolder;
import org.ssssssss.magicapi.servlet.javaee.MagicJavaEEResponseExtension;
import org.ssssssss.magicapi.servlet.javaee.MagicJavaEEWebRequestInterceptor;

@Configuration
public class MagicJavaEEServletConfiguration
implements WebMvcConfigurer {
    private final MagicAPIProperties properties;
    private final ObjectProvider<MagicJavaEEWebRequestInterceptor> magicWebRequestInterceptorProvider;
    private MagicJavaEECorsFilter magicCorsFilter = new MagicJavaEECorsFilter();

    public MagicJavaEEServletConfiguration(MagicAPIProperties properties, ObjectProvider<MagicJavaEEWebRequestInterceptor> magicWebRequestInterceptorProvider) {
        this.properties = properties;
        this.magicWebRequestInterceptorProvider = magicWebRequestInterceptorProvider;
    }

    @Bean
    public MagicRequestContextHolder magicRequestContextHolder(MultipartResolver multipartResolver) {
        return new MagicJavaEERequestContextHolder(multipartResolver);
    }

    @Bean
    public MagicJavaEEWebRequestInterceptor magicWebRequestInterceptor(AuthorizationInterceptor authorizationInterceptor) {
        return new MagicJavaEEWebRequestInterceptor(this.properties.isSupportCrossDomain() ? this.magicCorsFilter : null, authorizationInterceptor);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.magicWebRequestInterceptorProvider.getObject()).addPathPatterns(new String[]{"/**"});
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new MagicJavaEEHttpServletRequest.ArgumentsResolver());
        resolvers.add(new MagicJavaEEHttpServletResponse.ArgumentsResolver());
    }

    @Bean
    public MagicJavaEEResponseExtension magicJavaEEResponseExtension() {
        return new MagicJavaEEResponseExtension();
    }

    @Bean
    @ConditionalOnProperty(prefix="magic-api", value={"support-cross-domain"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<MagicJavaEECorsFilter> magicCorsFilterRegistrationBean() {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)this.magicCorsFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("Magic Cors Filter");
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }
}

