/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.stat;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.tio.utils.SystemTimer;
import org.tio.utils.hutool.BetweenFormater;

public class IpStat
implements Serializable {
    private static final long serialVersionUID = -6942731710053482089L;
    private Date start = new Date();
    private long duration;
    private Long durationType;
    private String ip;
    private AtomicInteger decodeErrorCount = new AtomicInteger();
    private AtomicInteger requestCount = new AtomicInteger();
    private AtomicLong sentBytes = new AtomicLong();
    private AtomicLong sentPackets = new AtomicLong();
    private AtomicLong handledBytes = new AtomicLong();
    private AtomicLong handledPackets = new AtomicLong();
    private AtomicLong handledPacketCosts = new AtomicLong();
    private AtomicLong receivedBytes = new AtomicLong();
    private AtomicLong receivedTcps = new AtomicLong();
    private AtomicLong receivedPackets = new AtomicLong();

    public IpStat(String ip, Long durationType) {
        this.ip = ip;
        this.durationType = durationType;
    }

    public double getBytesPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        double ret = (double)this.receivedBytes.get() / (double)this.receivedTcps.get();
        return ret;
    }

    public AtomicInteger getDecodeErrorCount() {
        return this.decodeErrorCount;
    }

    public long getDuration() {
        this.duration = SystemTimer.currTime - this.start.getTime();
        return this.duration;
    }

    public Long getDurationType() {
        return this.durationType;
    }

    public String getFormatedDuration() {
        this.duration = SystemTimer.currTime - this.start.getTime();
        BetweenFormater betweenFormater = new BetweenFormater(this.duration, BetweenFormater.Level.MILLSECOND);
        return betweenFormater.format();
    }

    public AtomicLong getHandledBytes() {
        return this.handledBytes;
    }

    public AtomicLong getHandledPackets() {
        return this.handledPackets;
    }

    public String getIp() {
        return this.ip;
    }

    public double getPacketsPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        double ret = (double)this.receivedPackets.get() / (double)this.receivedTcps.get();
        return ret;
    }

    public AtomicLong getReceivedBytes() {
        return this.receivedBytes;
    }

    public AtomicLong getReceivedPackets() {
        return this.receivedPackets;
    }

    public AtomicLong getReceivedTcps() {
        return this.receivedTcps;
    }

    public AtomicInteger getRequestCount() {
        return this.requestCount;
    }

    public AtomicLong getSentBytes() {
        return this.sentBytes;
    }

    public AtomicLong getSentPackets() {
        return this.sentPackets;
    }

    public Date getStart() {
        return this.start;
    }

    public void setDurationType(Long durationType) {
        this.durationType = durationType;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public AtomicLong getHandledPacketCosts() {
        return this.handledPacketCosts;
    }

    public double getHandledCostsPerPacket() {
        if (this.handledPackets.get() > 0L) {
            return this.handledPacketCosts.get() / this.handledPackets.get();
        }
        return 0.0;
    }
}

