/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.util;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResource;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseStatus;
import org.tio.http.common.MimeType;
import org.tio.http.common.RequestLine;
import org.tio.utils.IoUtils;
import org.tio.utils.hutool.ClassUtil;
import org.tio.utils.hutool.FileUtil;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.Json;

public class Resps {
    private static Logger log = LoggerFactory.getLogger(Resps.class);

    public static HttpResponse css(HttpRequest request, String bodyString) {
        return Resps.css(request, bodyString, request.httpConfig.getCharset());
    }

    public static HttpResponse css(HttpRequest request, String bodyString, String charset) {
        HttpResponse ret = Resps.string(request, bodyString, charset, Resps.getMimeTypeStr(MimeType.TEXT_CSS_CSS, charset));
        return ret;
    }

    public static HttpResponse bytes(HttpRequest request, byte[] bodyBytes, String extension) {
        String contentType = null;
        if (StrUtil.isNotBlank((CharSequence)extension)) {
            MimeType mimeType = MimeType.fromExtension((String)extension);
            contentType = mimeType != null ? mimeType.getType() : "application/octet-stream";
        }
        return Resps.bytesWithContentType(request, bodyBytes, contentType);
    }

    public static HttpResponse file(HttpRequest request, File fileOnServer) throws Exception {
        if (fileOnServer == null || !fileOnServer.exists()) {
            return request.httpConfig.getHttpRequestHandler().resp404(request, request.getRequestLine());
        }
        Date lastModified = new Date(fileOnServer.lastModified());
        HttpResponse ret = Resps.try304(request, lastModified.getTime());
        if (ret != null) {
            return ret;
        }
        byte[] bodyBytes = Files.readAllBytes(fileOnServer.toPath());
        String filename = fileOnServer.getName();
        String extension = FileUtil.extName((String)filename);
        ret = Resps.bytes(request, bodyBytes, extension);
        ret.setLastModified(HeaderValue.from((String)(lastModified.getTime() + "")));
        return ret;
    }

    public static HttpResponse file(HttpRequest request, String path) throws Exception {
        HttpResource httpResource = request.httpConfig.getResource(request, path);
        if (httpResource == null) {
            return null;
        }
        String path1 = httpResource.getPath();
        File file = httpResource.getFile();
        if (file != null) {
            return Resps.file(request, file);
        }
        InputStream inputStream = httpResource.getInputStream();
        byte[] bs = IoUtils.toByteArray((InputStream)inputStream);
        return Resps.bytes(request, bs, FileUtil.extName((String)path1));
    }

    public static HttpResponse resp404(HttpRequest request, RequestLine requestLine, HttpConfig httpConfig) throws Exception {
        String file404 = httpConfig.getPage404();
        HttpResource httpResource = request.httpConfig.getResource(request, file404);
        if (httpResource != null) {
            HttpResponse ret = Resps.forward(request, file404 + "?tio_initpath=" + URLEncoder.encode(requestLine.getPathAndQuery(), httpConfig.getCharset()));
            return ret;
        }
        HttpResponse ret = Resps.html(request, "404");
        ret.setStatus(HttpResponseStatus.C404);
        return ret;
    }

    public static HttpResponse resp404(HttpRequest request) throws Exception {
        return Resps.resp404(request, request.requestLine, request.httpConfig);
    }

    public static HttpResponse resp500(HttpRequest request, RequestLine requestLine, HttpConfig httpConfig, Throwable throwable) throws Exception {
        String file500 = httpConfig.getPage500();
        HttpResource httpResource = request.httpConfig.getResource(request, file500);
        if (httpResource != null) {
            HttpResponse ret = Resps.forward(request, file500 + "?tio_initpath=" + requestLine.getPathAndQuery());
            return ret;
        }
        HttpResponse ret = Resps.html(request, "500");
        ret.setStatus(HttpResponseStatus.C500);
        return ret;
    }

    public static HttpResponse resp500(HttpRequest request, Throwable throwable) throws Exception {
        return Resps.resp500(request, request.requestLine, request.httpConfig, throwable);
    }

    public static HttpResponse bytesWithContentType(HttpRequest request, byte[] bodyBytes, String contentType) {
        HttpResponse ret = new HttpResponse(request);
        ret.setBody(bodyBytes);
        if (StrUtil.isBlank((CharSequence)contentType)) {
            ret.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.DEFAULT_TYPE);
        } else {
            ret.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.from((String)contentType));
        }
        return ret;
    }

    public static HttpResponse bytesWithHeaders(HttpRequest request, byte[] bodyBytes, Map<HeaderName, HeaderValue> headers) {
        HttpResponse ret = new HttpResponse(request);
        ret.setBody(bodyBytes);
        ret.addHeaders(headers);
        return ret;
    }

    public static HttpResponse html(HttpRequest request, String bodyString) {
        return Resps.html(request, bodyString, request.httpConfig.getCharset());
    }

    public static HttpResponse forward(HttpRequest request, String newPath) throws Exception {
        return request.forward(newPath);
    }

    public static HttpResponse html(HttpRequest request, String bodyString, String charset) {
        HttpResponse ret = Resps.string(request, bodyString, charset, Resps.getMimeTypeStr(MimeType.TEXT_HTML_HTML, charset));
        return ret;
    }

    public static HttpResponse js(HttpRequest request, String bodyString) {
        return Resps.js(request, bodyString, request.httpConfig.getCharset());
    }

    public static HttpResponse js(HttpRequest request, String bodyString, String charset) {
        HttpResponse ret = Resps.string(request, bodyString, charset, Resps.getMimeTypeStr(MimeType.APPLICATION_JAVASCRIPT_JS, charset));
        return ret;
    }

    public static HttpResponse json(HttpRequest request, Object body) {
        return Resps.json(request, body, request.httpConfig.getCharset());
    }

    public static HttpResponse json(HttpRequest request, Object body, String charset) {
        HttpResponse ret = null;
        ret = body == null ? Resps.string(request, "", charset, Resps.getMimeTypeStr(MimeType.TEXT_PLAIN_JSON, charset)) : (body.getClass() == String.class || ClassUtil.isBasicType(body.getClass()) ? Resps.string(request, body + "", charset, Resps.getMimeTypeStr(MimeType.TEXT_PLAIN_JSON, charset)) : Resps.string(request, Json.toJson((Object)body), charset, Resps.getMimeTypeStr(MimeType.TEXT_PLAIN_JSON, charset)));
        return ret;
    }

    private static String getMimeTypeStr(MimeType mimeType, String charset) {
        if (charset == null) {
            return mimeType.getType();
        }
        return mimeType.getType() + ";charset=" + charset;
    }

    public static HttpResponse redirect(HttpRequest request, String path) {
        return Resps.redirect(request, path, HttpResponseStatus.C302);
    }

    public static HttpResponse redirectForever(HttpRequest request, String path) {
        return Resps.redirect(request, path, HttpResponseStatus.C301);
    }

    public static HttpResponse redirect(HttpRequest request, String path, HttpResponseStatus status) {
        HttpResponse ret = new HttpResponse(request);
        ret.setStatus(status);
        ret.addHeader(HeaderName.Location, HeaderValue.from((String)path));
        return ret;
    }

    public static HttpResponse redirectWithPage(HttpRequest request, String path) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("<script>");
        sb.append("window.location.href='").append(path).append("'");
        sb.append("</script>");
        return Resps.html(request, sb.toString());
    }

    public static HttpResponse string(HttpRequest request, String bodyString, String Content_Type2) {
        return Resps.string(request, bodyString, request.httpConfig.getCharset(), Content_Type2);
    }

    public static HttpResponse string(HttpRequest request, String bodyString, String charset, String Content_Type2) {
        HttpResponse ret = new HttpResponse(request);
        if (bodyString != null) {
            if (charset == null) {
                ret.setBody(bodyString.getBytes());
            } else {
                try {
                    ret.setBody(bodyString.getBytes(charset));
                }
                catch (UnsupportedEncodingException e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }
        ret.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.from((String)Content_Type2));
        return ret;
    }

    public static HttpResponse try304(HttpRequest request, long lastModifiedOnServer) {
        String If_Modified_Since = request.getHeader("if-modified-since");
        if (StrUtil.isNotBlank((CharSequence)If_Modified_Since)) {
            Long If_Modified_Since_Date = null;
            try {
                If_Modified_Since_Date = Long.parseLong(If_Modified_Since);
                if (lastModifiedOnServer <= If_Modified_Since_Date) {
                    HttpResponse ret = new HttpResponse(request);
                    ret.setStatus(HttpResponseStatus.C304);
                    return ret;
                }
            }
            catch (NumberFormatException e) {
                log.warn("{}, {}\u4e0d\u662f\u6574\u6570\uff0c\u6d4f\u89c8\u5668\u4fe1\u606f:{}", new Object[]{request.getClientIp(), If_Modified_Since, request.getUserAgent()});
                return null;
            }
        }
        return null;
    }

    public static HttpResponse txt(HttpRequest request, String bodyString) {
        return Resps.txt(request, bodyString, request.httpConfig.getCharset());
    }

    public static HttpResponse txt(HttpRequest request, String bodyString, String charset) {
        HttpResponse ret = Resps.string(request, bodyString, charset, Resps.getMimeTypeStr(MimeType.TEXT_PLAIN_TXT, charset));
        return ret;
    }

    private Resps() {
    }
}

