/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.hutool.FileUtil;
import org.tio.utils.hutool.StrUtil;

public class TioTools {
    private static Logger log = LoggerFactory.getLogger(TioTools.class);
    private static Set<String> acceptedExt = new HashSet<String>();
    private static int modifiedCount;

    public static void main(String[] args) throws Exception {
        TioTools.tio();
    }

    public static void printFiles() {
        File f = new File("F:\\work\\tio-site\\src\\frontend\\web-all\\starter\\src\\main\\resources\\config\\page\\img\\avatar");
        File[] list = f.listFiles();
        String str = "{";
        for (File file : list) {
            str = str + "\"/img/avatar/" + file.getName() + "\",";
        }
        str = str + "}";
        System.out.println(str);
    }

    public static void rename(String rootDirStr, Map<String, String> old2newFilename) throws IOException {
        File file;
        int i;
        if (old2newFilename == null || old2newFilename.size() == 0) {
            return;
        }
        File rootDir = new File(rootDirStr);
        File[] files = rootDir.listFiles();
        for (i = 0; i < files.length; ++i) {
            file = files[i];
            String filename = file.getName();
            Set<Map.Entry<String, String>> old2newFilenameSet = old2newFilename.entrySet();
            for (Map.Entry<String, String> entry : old2newFilenameSet) {
                String oldfilenamefragment = entry.getKey();
                String newfilenamefragment = entry.getValue();
                if (!filename.contains(oldfilenamefragment)) continue;
                String newfilename = filename.replaceAll(oldfilenamefragment, newfilenamefragment);
                File newFile = new File(file.getParentFile(), newfilename);
                boolean f = file.renameTo(newFile);
                file = newFile;
                if (f) {
                    System.out.println("\u6539\u540d\u6210\u529f\uff0c\u539f\u540d:" + filename + ", \u65b0\u540d\uff1a" + newfilename + ", " + file.getAbsolutePath());
                    continue;
                }
                System.out.println("\u6539\u540d\u5931\u8d25\uff0c\u539f\u540d:" + filename + ", \u65b0\u540d\uff1a" + newfilename + ", " + file.getAbsolutePath());
            }
        }
        rootDir = new File(rootDirStr);
        files = rootDir.listFiles(new MyFileFilter());
        for (i = 0; i < files.length; ++i) {
            file = files[i];
            if (!file.isDirectory()) continue;
            TioTools.rename(file.getAbsolutePath(), old2newFilename);
        }
    }

    public static void replaceStr(String rootDirStr, Map<String, String> old2newStr) throws Exception {
        if (old2newStr == null) {
            return;
        }
        File rootDir = new File(rootDirStr);
        File[] files = rootDir.listFiles(new MyFileFilter());
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String absolutePath = file.getAbsolutePath();
            if (file.isFile() && !"TioTools.java".equals(file.getName())) {
                String filecontent = FileUtil.readUTF8String(file);
                boolean needRewrite = false;
                Set<Map.Entry<String, String>> old2newStrSet = old2newStr.entrySet();
                for (Map.Entry<String, String> entry1 : old2newStrSet) {
                    String oldstrfragment = entry1.getKey();
                    String newstrfragment = entry1.getValue();
                    if (!filecontent.contains(oldstrfragment)) continue;
                    filecontent = filecontent.replaceAll(oldstrfragment, newstrfragment);
                    needRewrite = true;
                }
                if (!needRewrite) continue;
                FileUtil.writeString(filecontent, file.getCanonicalPath(), "utf-8");
                System.out.println(++modifiedCount + "\u3001" + file.getAbsolutePath());
                continue;
            }
            if (!file.isDirectory()) continue;
            TioTools.replaceStr(absolutePath, old2newStr);
        }
    }

    public static void tio() {
        String[] rootDirStrs = new String[]{"F:\\work\\tio-site", "F:\\work\\nb", "D:\\work\\tio-im", "D:\\svn_nb\\base", "G:\\work", "D:\\work\\dts", "D:\\work\\tio-webpack", "D:\\svn_nb\\nbyb", "D:\\work\\t-io", "D:\\work\\tio-start", "F:\\gitee", "D:\\work\\tio-im(\u6539\u540d\u524d)", "F:\\work\\nb"};
        String newversion = "3.2.5.v20190101-RELEASE";
        HashMap<String, String> old2newStr = new HashMap<String, String>();
        old2newStr.put("3.2.4.v20181218-RELEASE", newversion);
        for (String rootDirStr : rootDirStrs) {
            try {
                TioTools.replaceStr(rootDirStr, old2newStr);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void newProject() {
        String[] rootDirStrs;
        for (String rootDirStr : rootDirStrs = new String[]{"D:\\work\\tio-im(\u6539\u540d\u524d)"}) {
            HashMap<String, String> old2newStr = new HashMap<String, String>();
            HashMap<String, String> old2newFilename = new HashMap<String, String>();
            String oldName = "im";
            String newName = "live";
            String splitStr = "-";
            splitStr = "-";
            old2newStr.put("tio" + splitStr + oldName, "tio" + splitStr + newName);
            old2newStr.put("tio" + splitStr + StrUtil.upperFirst(oldName), "tio" + splitStr + StrUtil.upperFirst(newName));
            old2newStr.put("Tio" + splitStr + oldName, "Tio" + splitStr + newName);
            old2newStr.put("Tio" + splitStr + StrUtil.upperFirst(oldName), "Tio" + splitStr + StrUtil.upperFirst(newName));
            old2newStr.put("TIO" + splitStr + oldName.toUpperCase(), "TIO" + splitStr + newName.toUpperCase());
            splitStr = "_";
            old2newStr.put("tio" + splitStr + oldName, "tio" + splitStr + newName);
            old2newStr.put("tio" + splitStr + StrUtil.upperFirst(oldName), "tio" + splitStr + StrUtil.upperFirst(newName));
            old2newStr.put("Tio" + splitStr + oldName, "Tio" + splitStr + newName);
            old2newStr.put("Tio" + splitStr + StrUtil.upperFirst(oldName), "Tio" + splitStr + StrUtil.upperFirst(newName));
            old2newStr.put("TIO" + splitStr + oldName.toUpperCase(), "TIO" + splitStr + newName.toUpperCase());
            splitStr = " ";
            old2newStr.put("tio" + splitStr + oldName, "tio" + splitStr + newName);
            old2newStr.put("tio" + splitStr + StrUtil.upperFirst(oldName), "tio" + splitStr + StrUtil.upperFirst(newName));
            old2newStr.put("Tio" + splitStr + oldName, "Tio" + splitStr + newName);
            old2newStr.put("Tio" + splitStr + StrUtil.upperFirst(oldName), "Tio" + splitStr + StrUtil.upperFirst(newName));
            old2newStr.put("TIO" + splitStr + oldName.toUpperCase(), "TIO" + splitStr + newName.toUpperCase());
            splitStr = "";
            old2newStr.put("tio" + splitStr + oldName, "tio" + splitStr + newName);
            old2newStr.put("tio" + splitStr + StrUtil.upperFirst(oldName), "tio" + splitStr + StrUtil.upperFirst(newName));
            old2newStr.put("Tio" + splitStr + oldName, "Tio" + splitStr + newName);
            old2newStr.put("Tio" + splitStr + StrUtil.upperFirst(oldName), "Tio" + splitStr + StrUtil.upperFirst(newName));
            old2newStr.put("TIO_LIVEEI", "TIO_IMEI");
            old2newStr.put("tio_liveei", "tio_imei");
            old2newStr.put("TIO-LIVEEI", "TIO-IMEI");
            old2newStr.put("tio-liveei", "tio-imei");
            old2newFilename.putAll(old2newStr);
            try {
                TioTools.rename(rootDirStr, old2newFilename);
                TioTools.replaceStr(rootDirStr, old2newStr);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void changeSiteStyle() {
        String[] rootDirStrs;
        for (String rootDirStr : rootDirStrs = new String[]{"F:\\work\\tio-site\\src\\frontend\\web-all\\starter\\src\\main\\resources\\config\\page"}) {
            HashMap<String, String> old2newStr = new HashMap<String, String>();
            HashMap<String, String> old2newFilename = new HashMap<String, String>();
            old2newStr.put("#00CC00", "#0000CC");
            old2newStr.put("#0376e0", "#03e076");
            old2newStr.put("#0099FF", "#00FF99");
            old2newStr.put("#0c7ac9", "#0cc97a");
            old2newStr.put("#00ff80", "#0080ff");
            old2newStr.put("#e7f5ff", "#e7fff5");
            old2newStr.put("#379ef8", "#37f89e");
            old2newStr.put("#9accf9", "#9af9cc");
            old2newStr.put("#6f6", "#66f");
            old2newStr.put("#108ee9", "#10e98e");
            old2newStr.put("#1E9FFF", "#1EFF9F");
            old2newStr.put("#00FF99", "#03e076");
            old2newFilename.putAll(old2newStr);
            try {
                TioTools.replaceStr(rootDirStr, old2newStr);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void rename() {
        String[] rootDirStrs;
        for (String rootDirStr : rootDirStrs = new String[]{"D:\\work\\tio-im", "F:\\gitee\\java", "D:\\work\\tio-im(\u6539\u540d\u524d)"}) {
            HashMap<String, String> old2newFilename = new HashMap<String, String>();
            old2newFilename.put("nb830.dic", "nb919.dic");
            try {
                TioTools.rename(rootDirStr, old2newFilename);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void replaceFiles(File newFile, String[] rootDirStrs) throws Exception {
        byte[] newBytes = FileUtil.readBytes(newFile);
        for (String rootDirStr : rootDirStrs) {
            try {
                TioTools.replaceFile(newFile, newBytes, rootDirStr);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void replaceFile(File newFile, byte[] newBytes, String rootDirStr) throws Exception {
        File rootDir = new File(rootDirStr);
        File[] files = rootDir.listFiles();
        if (files.length != 0) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String absolutePath = file.getAbsolutePath();
                if (file.isDirectory()) {
                    TioTools.replaceFile(newFile, newBytes, absolutePath);
                    continue;
                }
                if (!file.getName().equals(newFile.getName())) continue;
                FileUtil.writeBytes(newBytes, file);
                System.out.println(file.getCanonicalPath());
            }
        }
    }

    public static void addBlankFile(String rootDirStr) {
        File rootDir = new File(rootDirStr);
        File[] files = rootDir.listFiles();
        if (files.length == 0) {
            File blankFile = new File(rootDir, "svn.txt");
            log.warn(blankFile.getAbsolutePath());
            try {
                blankFile.createNewFile();
            }
            catch (IOException e) {
                log.error(e.toString(), (Throwable)e);
            }
        } else {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String absolutePath = file.getAbsolutePath();
                if (!file.isDirectory()) continue;
                TioTools.addBlankFile(absolutePath);
            }
        }
    }

    public static void findFile(String rootDirStr, String searchStr, AtomicInteger count) {
        File rootDir = new File(rootDirStr);
        File[] files = rootDir.listFiles();
        if (files.length != 0) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    File file = files[i];
                    String absolutePath = file.getAbsolutePath();
                    if (StrUtil.containsAny(file.getName(), searchStr)) {
                        if (file.isDirectory()) {
                            log.warn("\r\n[dir ]" + file.getAbsolutePath());
                        } else {
                            log.warn("\r\n[file]" + file.getAbsolutePath());
                        }
                        count.incrementAndGet();
                    }
                    if (!file.isDirectory()) continue;
                    TioTools.findFile(absolutePath, searchStr, count);
                    continue;
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }
    }

    public static void deleteFiles(String[] rootDirStrs, String[] filenames) {
        for (String rootDirStr : rootDirStrs) {
            try {
                TioTools.deleteFile(rootDirStr, filenames);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }

    public static void deleteFile(String rootDirStr, String[] filenames) {
        File rootDir = new File(rootDirStr);
        File[] files = rootDir.listFiles();
        if (files.length != 0) {
            block2: for (int i = 0; i < files.length; ++i) {
                try {
                    File file = files[i];
                    String absolutePath = file.getAbsolutePath();
                    for (int j = 0; j < filenames.length; ++j) {
                        if (!file.getName().equals(filenames[j])) continue;
                        FileUtil.del(file);
                        log.warn(file.getAbsolutePath());
                        continue block2;
                    }
                    if (!file.isDirectory()) continue;
                    TioTools.deleteFile(absolutePath, filenames);
                    continue;
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }
    }

    static {
        acceptedExt.add("js");
        acceptedExt.add("jsp");
        acceptedExt.add("xml");
        acceptedExt.add("bat");
        acceptedExt.add("sh");
        acceptedExt.add("java");
        acceptedExt.add("properties");
        acceptedExt.add("sql");
        acceptedExt.add("txt");
        acceptedExt.add("log");
        acceptedExt.add("css");
        acceptedExt.add("md");
        acceptedExt.add("form");
        acceptedExt.add("dic");
        modifiedCount = 0;
    }

    static class MyFileFilter
    implements FileFilter {
        MyFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            String absolutePath = file.getAbsolutePath();
            String filename = file.getName();
            String extension = FileUtil.extName(filename);
            if (file.isDirectory()) {
                if (absolutePath.contains("\\webapp\\js") || absolutePath.contains("-app\\nginx\\cache") || absolutePath.contains("nginx\\html\\js") || filename.equals("target")) {
                    return false;
                }
                return !"svn-base".equalsIgnoreCase(extension);
            }
            String ext = FileUtil.extName(file);
            return acceptedExt.contains(ext);
        }
    }
}

