/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.File;
import org.teiid.core.util.StringUtil;

public final class FileUtils {
    private FileUtils() {
    }

    public static String getBaseFileNameWithoutExtension(String path) {
        return StringUtil.getFirstToken(StringUtil.getLastToken(path, "/"), ".");
    }

    public static void removeDirectoryAndChildren(File directory) {
        FileUtils.removeChildrenRecursively(directory);
        if (!directory.delete()) {
            directory.deleteOnExit();
        }
    }

    public static void removeChildrenRecursively(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    FileUtils.removeDirectoryAndChildren(file);
                    continue;
                }
                FileUtils.remove(file);
            }
        }
    }

    public static void remove(File file) {
        if (file.exists() && !file.delete()) {
            file.deleteOnExit();
        }
    }
}

