/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.binary.BitString;
import org.uncommons.maths.number.ConstantGenerator;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitStringMutation
implements EvolutionaryOperator<BitString> {
    private final NumberGenerator<Probability> mutationProbability;

    public BitStringMutation(Probability mutationProbability) {
        this((NumberGenerator<Probability>)new ConstantGenerator((Number)mutationProbability));
    }

    public BitStringMutation(NumberGenerator<Probability> mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    @Override
    public List<BitString> apply(List<BitString> selectedCandidates, Random rng) {
        ArrayList<BitString> mutatedPopulation = new ArrayList<BitString>(selectedCandidates.size());
        for (BitString b : selectedCandidates) {
            mutatedPopulation.add(this.mutateBitString(b, rng));
        }
        return mutatedPopulation;
    }

    private BitString mutateBitString(BitString bitString, Random rng) {
        BitString mutatedBitString = bitString.clone();
        for (int i = 0; i < mutatedBitString.getLength(); ++i) {
            if (!((Probability)this.mutationProbability.nextValue()).nextEvent(rng)) continue;
            mutatedBitString.flipBit(i);
        }
        return mutatedBitString;
    }
}

