/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.Expression;
import org.xbib.jdbc.csv.LogicalExpression;

class AndExpression
extends LogicalExpression {
    LogicalExpression left;
    LogicalExpression right;
    boolean isValid;

    public AndExpression(Expression left, Expression right) {
        boolean bl = this.isValid = left instanceof LogicalExpression && right instanceof LogicalExpression;
        if (this.isValid) {
            this.left = (LogicalExpression)left;
            this.right = (LogicalExpression)right;
            this.isValid = left.isValid() && right.isValid();
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public boolean isTrue(Map<String, Object> env) throws SQLException {
        return this.left.isTrue(env) && this.right.isTrue(env);
    }

    public String toString() {
        return "AND " + this.left + " " + this.right;
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.left.usedColumns());
        result.addAll(this.right.usedColumns());
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.left.aggregateFunctions());
        result.addAll(this.right.aggregateFunctions());
        return result;
    }
}

