/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.Expression;
import org.xbib.jdbc.csv.LogicalExpression;
import org.xbib.jdbc.csv.RelopExpression;

class BetweenExpression
extends LogicalExpression {
    Expression obj;
    Expression left;
    Expression right;

    public BetweenExpression(Expression obj, Expression left, Expression right) {
        this.obj = obj;
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean isTrue(Map<String, Object> env) throws SQLException {
        Integer comparedRight;
        Comparable leftValue = (Comparable)this.left.eval(env);
        Comparable rightValue = (Comparable)this.right.eval(env);
        Comparable objValue = (Comparable)this.obj.eval(env);
        Integer comparedLeft = RelopExpression.compare(leftValue, objValue, env);
        boolean result = false;
        if (comparedLeft != null && comparedLeft <= 0 && (comparedRight = RelopExpression.compare(rightValue, objValue, env)) != null && comparedRight >= 0) {
            result = true;
        }
        return result;
    }

    public String toString() {
        return "B " + this.obj + " " + this.left + " " + this.right;
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.obj.usedColumns());
        result.addAll(this.left.usedColumns());
        result.addAll(this.right.usedColumns());
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.obj.aggregateFunctions());
        result.addAll(this.left.aggregateFunctions());
        result.addAll(this.right.aggregateFunctions());
        return result;
    }
}

