/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;
import org.xbib.jdbc.csv.CsvDatabaseMetaData;
import org.xbib.jdbc.csv.CsvDriver;
import org.xbib.jdbc.csv.CsvPreparedStatement;
import org.xbib.jdbc.csv.CsvResources;
import org.xbib.jdbc.csv.CsvStatement;
import org.xbib.jdbc.csv.StringConverter;
import org.xbib.jdbc.csv.ZipFileTableReader;
import org.xbib.jdbc.io.CryptoFilter;
import org.xbib.jdbc.io.TableReader;

public class CsvConnection
implements Connection {
    private String path;
    private String urlProperties;
    private TableReader tableReader;
    private String extension = ".csv";
    private String separator = ",";
    private Character quotechar = Character.valueOf('\"');
    private HashMap<String, String> headerlines = new HashMap();
    private boolean suppressHeaders = false;
    private boolean isHeaderFixedWidth = true;
    private boolean trimHeaders = true;
    private boolean trimValues = false;
    private boolean indexedFiles = false;
    private HashMap<String, String> columnTypes = new HashMap();
    private Vector<Statement> statements = new Vector();
    private String charset = null;
    private boolean closed;
    private String fileNamePattern;
    private String[] nameParts;
    private String timestampFormat;
    private String dateFormat;
    private String timeFormat;
    private String timeZoneName;
    private Locale locale = null;
    private String commentChar;
    private int skipLeadingLines = 0;
    private boolean ignoreUnparseableLines;
    private boolean fileTailPrepend;
    private CryptoFilter decryptingFilter;
    private boolean defectiveHeaders;
    private int skipLeadingDataLines;
    private int transposedLines;
    private int transposedFieldsToSkip;
    private boolean autoCommit;
    private String quoteStyle;
    private ArrayList<int[]> fixedWidthColumns = null;
    private HashMap<String, Method> sqlFunctions = new HashMap();

    private void init() {
        this.headerlines.put(null, CsvDriver.DEFAULT_HEADERLINE);
        this.columnTypes.put(null, "String");
    }

    protected CsvConnection(String path) {
        this.init();
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException(CsvResources.getString("noPath"));
        }
        this.path = path;
        this.urlProperties = "";
    }

    private Map<String, String> getMatchingProperties(Properties info, String prefix) {
        HashMap<String, String> retval = new HashMap<String, String>();
        for (Object o : info.keySet()) {
            String key = o.toString();
            if (!key.startsWith(prefix)) continue;
            String value = info.getProperty(key);
            key = key.substring(prefix.length());
            retval.put(key, value);
        }
        return retval;
    }

    private void setFunctions(Properties info) throws SQLException {
        String prefix = "function.";
        for (Map.Entry<String, String> entry : this.getMatchingProperties(info, prefix).entrySet()) {
            String functionName = entry.getKey().toUpperCase();
            String javaName = entry.getValue();
            try {
                for (int i = 0; i < functionName.length(); ++i) {
                    char c = functionName.charAt(i);
                    if (Character.isLetterOrDigit(c) || c == '_' || c == '.') continue;
                    throw new SQLException(CsvResources.getString("invalidFunction") + ": " + functionName);
                }
                int openParenIndex = javaName.indexOf(40);
                if (openParenIndex < 0) {
                    throw new SQLException(CsvResources.getString("noFunctionClass") + ": " + javaName);
                }
                String definition = javaName.substring(0, openParenIndex).trim();
                String parameterNames = javaName.substring(openParenIndex + 1);
                int closeParenIndex = parameterNames.lastIndexOf(41);
                if (closeParenIndex < 0) {
                    throw new SQLException(CsvResources.getString("noFunctionClass") + ": " + javaName);
                }
                parameterNames = parameterNames.substring(0, closeParenIndex).trim();
                int lastDotIndex = definition.lastIndexOf(46);
                if (lastDotIndex < 0) {
                    throw new SQLException(CsvResources.getString("noFunctionClass") + ": " + definition);
                }
                String className = definition.substring(0, lastDotIndex);
                Class<?> clazz = Class.forName(className);
                String methodName = definition.substring(lastDotIndex + 1);
                String[] parameters = new String[]{};
                boolean isVarArgs = false;
                if (parameterNames.length() > 0) {
                    parameters = parameterNames.split(",");
                    for (int i = 0; i < parameters.length; ++i) {
                        int dotIndex = parameters[i].indexOf("...");
                        if (i == parameters.length - 1 && dotIndex >= 0) {
                            parameters[i] = parameters[i].substring(0, dotIndex) + "[]";
                            isVarArgs = true;
                        }
                        parameters[i] = parameters[i].trim();
                        String[] split = parameters[i].split("\\s+");
                        if (split.length <= 1) continue;
                        parameters[i] = split[0];
                    }
                }
                Method[] methods = clazz.getMethods();
                boolean methodFound = false;
                for (int i = 0; i < methods.length && !methodFound; ++i) {
                    if (!methods[i].getName().equals(methodName) || (methods[i].getModifiers() & 8) == 0) continue;
                    Class<?>[] methodParameters = methods[i].getParameterTypes();
                    boolean matchingParameters = methodParameters.length == parameters.length && methods[i].isVarArgs() == isVarArgs;
                    for (int j = 0; j < methodParameters.length && matchingParameters; ++j) {
                        String methodParameterName = methodParameters[j].getSimpleName();
                        if (methodParameterName.equals(parameters[j])) continue;
                        matchingParameters = false;
                    }
                    if (!matchingParameters) continue;
                    this.sqlFunctions.put(functionName, methods[i]);
                    methodFound = true;
                }
                if (methodFound) continue;
                throw new SQLException(CsvResources.getString("noFunctionMethod") + ": " + javaName);
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(CsvResources.getString("noFunctionClass") + ": " + javaName, e);
            }
        }
    }

    private void setProperties(Properties info) throws SQLException {
        String prop;
        if (info.getProperty("fileExtension") != null) {
            this.extension = info.getProperty("fileExtension");
        }
        if (info.getProperty("separator") != null) {
            this.separator = info.getProperty("separator");
            if (this.separator.length() == 0) {
                throw new SQLException(CsvResources.getString("invalid") + " " + "separator" + ": " + this.separator);
            }
        }
        if ((prop = info.getProperty("quotechar")) != null) {
            if (prop.length() == 1) {
                this.quotechar = Character.valueOf(prop.charAt(0));
            } else if (prop.length() == 0) {
                this.quotechar = null;
            } else {
                throw new SQLException(CsvResources.getString("invalid") + " " + "quotechar" + ": " + prop);
            }
        }
        if (info.getProperty("headerline") != null) {
            this.headerlines.put(null, info.getProperty("headerline"));
        }
        this.headerlines.putAll(this.getMatchingProperties(info, "headerline."));
        if (info.getProperty("suppressHeaders") != null) {
            this.suppressHeaders = Boolean.valueOf(info.getProperty("suppressHeaders"));
        }
        if (info.getProperty("isHeaderFixedWidth") != null) {
            this.isHeaderFixedWidth = Boolean.valueOf(info.getProperty("isHeaderFixedWidth"));
        }
        if (info.getProperty("trimValues") != null) {
            this.trimValues = Boolean.valueOf(info.getProperty("trimValues"));
        }
        if (info.getProperty("charset") != null) {
            this.charset = info.getProperty("charset");
        }
        if (info.getProperty("columnTypes") != null) {
            this.columnTypes.put(null, info.getProperty("columnTypes"));
        }
        this.columnTypes.putAll(this.getMatchingProperties(info, "columnTypes."));
        if (info.getProperty("indexedFiles") != null) {
            this.indexedFiles = Boolean.valueOf(info.getProperty("indexedFiles"));
            this.fileNamePattern = info.getProperty("fileTailPattern");
            String fileTailParts = info.getProperty("fileTailParts", "");
            if (!fileTailParts.isEmpty()) {
                this.nameParts = fileTailParts.split(",");
            }
            this.setFileTailPrepend(Boolean.parseBoolean(info.getProperty("fileTailPrepend", "False")));
        }
        this.decryptingFilter = null;
        if (info.getProperty("cryptoFilterClassName") != null) {
            String className = info.getProperty("cryptoFilterClassName");
            try {
                Class<?> encrypterClass = Class.forName(className);
                String[] parameterTypes = info.getProperty("cryptoFilterParameterTypes", "String").split(",");
                String[] parameterStrings = info.getProperty("cryptoFilterParameters", "").split(",");
                StringConverter converter = new StringConverter("", "", "", "", null);
                Class[] parameterClasses = new Class[parameterStrings.length];
                Object[] parameterValues = new Object[parameterStrings.length];
                for (int i = 0; i < parameterStrings.length; ++i) {
                    parameterClasses[i] = converter.forSQLName(parameterTypes[i]);
                    parameterValues[i] = converter.convert(parameterTypes[i], parameterStrings[i]);
                }
                Constructor<?> constructor = encrypterClass.getConstructor(parameterClasses);
                this.decryptingFilter = (CryptoFilter)constructor.newInstance(parameterValues);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(CsvResources.getString("noCodecClass") + ": " + className);
            }
            if (this.decryptingFilter == null) {
                throw new SQLException(CsvResources.getString("noCryptoFilter"));
            }
        }
        this.setFunctions(info);
        String fixedWidths = info.getProperty("fixedWidths");
        if (fixedWidths != null) {
            this.fixedWidthColumns = new ArrayList();
            String[] columnRanges = fixedWidths.split(",");
            for (int i = 0; i < columnRanges.length; ++i) {
                int beginColumn;
                int endColumn;
                int dashIndex = columnRanges[i].indexOf(45);
                if (dashIndex < 0) {
                    beginColumn = endColumn = Integer.parseInt(columnRanges[i].trim());
                } else {
                    beginColumn = Integer.parseInt(columnRanges[i].substring(0, dashIndex).trim());
                    endColumn = Integer.parseInt(columnRanges[i].substring(dashIndex + 1).trim());
                }
                this.fixedWidthColumns.add(new int[]{beginColumn - 1, endColumn - 1});
            }
        }
        this.setTransposedLines(Integer.parseInt(info.getProperty("transposedLines", "0")));
        this.setTransposedFieldsToSkip(Integer.parseInt(info.getProperty("transposedFieldsToSkip", "0")));
        this.setTimestampFormat(info.getProperty("timestampFormat", CsvDriver.DEFAULT_TIMESTAMP_FORMAT));
        this.setDateFormat(info.getProperty("dateFormat", "YYYY-MM-DD"));
        this.setTimeFormat(info.getProperty("timeFormat", "HH:mm:ss"));
        this.setTimeZoneName(info.getProperty("timeZoneName", "UTC"));
        if (info.getProperty("locale") != null) {
            prop = info.getProperty("locale");
            Locale[] availableLocales = Locale.getAvailableLocales();
            for (int i = 0; i < availableLocales.length && this.locale == null; ++i) {
                String localeString = availableLocales[i].toString();
                if (!localeString.equals(prop)) continue;
                this.locale = availableLocales[i];
            }
            if (this.locale == null) {
                throw new SQLException(CsvResources.getString("noLocale") + ": " + prop);
            }
        }
        this.setCommentChar(info.getProperty("commentChar", CsvDriver.DEFAULT_COMMENT_CHAR));
        this.setDefectiveHeaders(info.getProperty("defectiveHeaders", "False"));
        this.setSkipLeadingDataLines(info.getProperty("skipLeadingDataLines", "0"));
        this.setSkipLeadingLines(info.getProperty("skipLeadingLines", CsvDriver.DEFAULT_SKIP_LEADING_LINES));
        this.setQuoteStyle(info.getProperty("quoteStyle", "SQL"));
        this.setIgnoreUnparseableLines(Boolean.parseBoolean(info.getProperty("ignoreNonParseableLines", "False")));
    }

    protected CsvConnection(String path, Properties info, String urlProperties) throws SQLException {
        this.init();
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException(CsvResources.getString("noPath"));
        }
        this.path = path;
        this.urlProperties = urlProperties;
        if (info != null) {
            this.setProperties(info);
        }
    }

    protected CsvConnection(TableReader tableReader, Properties info, String urlProperties) throws SQLException {
        this.init();
        this.tableReader = tableReader;
        this.urlProperties = urlProperties;
        if (info != null) {
            this.setProperties(info);
        }
    }

    private void setQuoteStyle(String property) {
        this.quoteStyle = property;
    }

    public String getQuoteStyle() {
        return this.quoteStyle;
    }

    private void setTimeZoneName(String property) {
        this.timeZoneName = property;
    }

    public String getTimeZoneName() {
        return this.timeZoneName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException(CsvResources.getString("closedConnection"));
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        CsvStatement statement = new CsvStatement(this, 1003);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        CsvPreparedStatement preparedStatement = new CsvPreparedStatement(this, sql, 1003);
        this.statements.add(preparedStatement);
        return preparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.prepareCall(String)");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.nativeSQL(String)");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    private synchronized void closeStatements() throws SQLException {
        while (this.statements.size() > 0) {
            this.statements.firstElement().close();
        }
        this.statements.clear();
    }

    @Override
    public void close() throws SQLException {
        this.closeStatements();
        this.closed = true;
    }

    public void removeStatement(Statement statement) {
        this.statements.remove(statement);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return new CsvDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.setTransactionIsolation(int)");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        CsvStatement statement = new CsvStatement(this, resultSetType);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        CsvPreparedStatement preparedStatement = new CsvPreparedStatement(this, sql, resultSetType);
        this.statements.add(preparedStatement);
        return preparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.prepareCall(String, int, int)");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.getTypeMap()");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.setTypeMap(Map)");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
        if (holdability != 1) {
            throw new SQLFeatureNotSupportedException(CsvResources.getString("unsupportedHoldability") + ": " + holdability);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        CsvStatement statement = new CsvStatement(this, resultSetType);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        CsvPreparedStatement preparedStatement = new CsvPreparedStatement(this, sql, resultSetType);
        this.statements.add(preparedStatement);
        return preparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.prepareCall(String,int,int,int)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.prepareStatement(String,int)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.prepareStatement(String,int[])");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.prepareStatement(String,String[])");
    }

    @Override
    public void releaseSavepoint(Savepoint savePoint) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.releaseSavepoint(Savepoint)");
    }

    @Override
    public void rollback(Savepoint savePoint) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.rollback(Savepoint)");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.setSavepoint()");
    }

    @Override
    public Savepoint setSavepoint(String str) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.setSavepoint(String)");
    }

    protected String getPath() {
        return this.path;
    }

    protected TableReader getTableReader() {
        return this.tableReader;
    }

    protected String getURL() {
        String url = this.path != null ? "jdbc:xbib:csv:" + this.path : (this.tableReader instanceof ZipFileTableReader ? "jdbc:xbib:csv:zip:" + ((ZipFileTableReader)this.tableReader).getZipFilename() : "jdbc:xbib:csv:class:" + this.tableReader.getClass().getName());
        return url + this.urlProperties;
    }

    protected String getExtension() {
        return this.extension;
    }

    protected String getSeparator() {
        return this.separator;
    }

    public String getHeaderline(String tableName) {
        String retval = this.headerlines.get(tableName);
        if (retval == null) {
            retval = this.headerlines.get(null);
        }
        return retval;
    }

    public Character getQuotechar() {
        return this.quotechar;
    }

    protected boolean isSuppressHeaders() {
        return this.suppressHeaders;
    }

    protected boolean isHeaderFixedWidth() {
        return this.isHeaderFixedWidth;
    }

    public ArrayList<int[]> getFixedWidthColumns() {
        return this.fixedWidthColumns;
    }

    protected boolean isDefectiveHeaders() {
        return this.defectiveHeaders;
    }

    protected int getSkipLeadingDataLines() {
        return this.skipLeadingDataLines;
    }

    protected String getCharset() {
        return this.charset;
    }

    public boolean getTrimHeaders() {
        return this.trimHeaders;
    }

    public boolean getTrimValues() {
        return this.trimValues;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    private void setDefectiveHeaders(String property) {
        this.defectiveHeaders = Boolean.parseBoolean(property);
    }

    private void setSkipLeadingDataLines(String property) {
        this.skipLeadingDataLines = Integer.parseInt(property);
    }

    @Deprecated
    public void setColumnTypes(String columnTypes) {
        this.columnTypes.put(null, columnTypes);
    }

    public String getColumnTypes(String tableName) {
        String retval = this.columnTypes.get(tableName);
        if (retval == null) {
            retval = this.columnTypes.get(null);
        }
        return retval;
    }

    @Deprecated
    public void setIndexedFiles(boolean indexedFiles) {
        this.indexedFiles = indexedFiles;
    }

    public boolean isIndexedFiles() {
        return this.indexedFiles;
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    public String[] getNameParts() {
        return this.nameParts;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setCommentChar(String value) {
        this.commentChar = value == null ? null : (value.equals("") ? null : value);
    }

    public String getCommentChar() {
        return this.commentChar;
    }

    private void setSkipLeadingLines(String property) {
        try {
            this.skipLeadingLines = Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            this.skipLeadingLines = 0;
        }
    }

    public int getSkipLeadingLines() {
        return this.skipLeadingLines;
    }

    public void setSkipLeadingLines(int skipLeadingLines) {
        this.skipLeadingLines = skipLeadingLines;
    }

    public boolean isIgnoreUnparseableLines() {
        return this.ignoreUnparseableLines;
    }

    public void setIgnoreUnparseableLines(boolean ignoreUnparseableLines) {
        this.ignoreUnparseableLines = ignoreUnparseableLines;
    }

    public void setFileTailPrepend(boolean fileTailPrepend) {
        this.fileTailPrepend = fileTailPrepend;
    }

    public boolean isFileTailPrepend() {
        return this.fileTailPrepend;
    }

    public CryptoFilter getDecryptingCodec() {
        return this.decryptingFilter;
    }

    public HashMap<String, Method> getSqlFunctions() {
        return this.sqlFunctions;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException(CsvResources.getString("methodNotSupported") + ": Connection.setNetworkTimeout(Executor,int)");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.abort(Executor)");
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
    }

    public int getTransposedLines() {
        return this.transposedLines;
    }

    private void setTransposedLines(int i) {
        this.transposedLines = i;
    }

    public int getTransposedFieldsToSkip() {
        return this.transposedFieldsToSkip;
    }

    public void setTransposedFieldsToSkip(int i) {
        this.transposedFieldsToSkip = i;
    }

    public List<String> getTableNames() throws SQLException {
        List<String> tableNames = new ArrayList<String>();
        if (this.path != null) {
            File[] matchingFiles = new File(this.path).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(CsvConnection.this.extension);
                }
            });
            for (int i = 0; i < matchingFiles.length; ++i) {
                if (!matchingFiles[i].isFile() || !matchingFiles[i].canRead()) continue;
                String filename = matchingFiles[i].getName();
                String tableName = filename.substring(0, filename.length() - this.extension.length());
                tableNames.add(tableName);
            }
        } else {
            List<String> list = this.tableReader.getTableNames(this);
            if (list != null) {
                tableNames = list;
            }
        }
        return tableNames;
    }
}

