/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.xbib.jdbc.csv.CsvConnection;
import org.xbib.jdbc.csv.CsvResources;
import org.xbib.jdbc.csv.CsvResultSet;
import org.xbib.jdbc.csv.ZipFileTableReader;
import org.xbib.jdbc.io.TableReader;

public class CsvDriver
implements Driver {
    public static final String DEFAULT_EXTENSION = ".csv";
    public static final String DEFAULT_SEPARATOR = ",";
    public static final char DEFAULT_QUOTECHAR = '\"';
    public static final String DEFAULT_HEADERLINE = null;
    public static final boolean DEFAULT_SUPPRESS = false;
    public static final boolean DEFAULT_IS_HEADER_FIXED_WIDTH = true;
    public static final boolean DEFAULT_TRIM_HEADERS = true;
    public static final boolean DEFAULT_TRIM_VALUES = false;
    public static final String DEFAULT_COLUMN_TYPES = "String";
    public static final boolean DEFAULT_INDEXED_FILES = false;
    public static final String DEFAULT_TIMESTAMP_FORMAT = null;
    public static final String DEFAULT_DATE_FORMAT = "YYYY-MM-DD";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_COMMENT_CHAR = null;
    public static final String DEFAULT_SKIP_LEADING_LINES = null;
    public static final String DEFAULT_IGNORE_UNPARSEABLE_LINES = "False";
    public static final String DEFAULT_FILE_TAIL_PREPEND = "False";
    public static final String DEFAULT_DEFECTIVE_HEADERS = "False";
    public static final String DEFAULT_SKIP_LEADING_DATA_LINES = "0";
    public static final String FILE_EXTENSION = "fileExtension";
    public static final String SEPARATOR = "separator";
    public static final String QUOTECHAR = "quotechar";
    public static final String HEADERLINE = "headerline";
    public static final String SUPPRESS_HEADERS = "suppressHeaders";
    public static final String IS_HEADER_FIXED_WIDTH = "isHeaderFixedWidth";
    public static final String TRIM_HEADERS = "trimHeaders";
    public static final String TRIM_VALUES = "trimValues";
    public static final String COLUMN_TYPES = "columnTypes";
    public static final String INDEXED_FILES = "indexedFiles";
    public static final String TIMESTAMP_FORMAT = "timestampFormat";
    public static final String DATE_FORMAT = "dateFormat";
    public static final String TIME_FORMAT = "timeFormat";
    public static final String LOCALE = "locale";
    public static final String COMMENT_CHAR = "commentChar";
    public static final String SKIP_LEADING_LINES = "skipLeadingLines";
    public static final String IGNORE_UNPARSEABLE_LINES = "ignoreNonParseableLines";
    public static final String FILE_TAIL_PREPEND = "fileTailPrepend";
    public static final String DEFECTIVE_HEADERS = "defectiveHeaders";
    public static final String SKIP_LEADING_DATA_LINES = "skipLeadingDataLines";
    public static final String TRANSPOSED_LINES = "transposedLines";
    public static final String TRANSPOSED_FIELDS_TO_SKIP = "transposedFieldsToSkip";
    public static final String CHARSET = "charset";
    public static final String URL_PREFIX = "jdbc:xbib:csv:";
    public static final String CRYPTO_FILTER_CLASS_NAME = "cryptoFilterClassName";
    public static final String TIME_ZONE_NAME = "timeZoneName";
    public static final String DEFAULT_TIME_ZONE_NAME = "UTC";
    public static final String QUOTE_STYLE = "quoteStyle";
    public static final String DEFAULT_QUOTE_STYLE = "SQL";
    public static final String READER_CLASS_PREFIX = "class:";
    public static final String ZIP_FILE_PREFIX = "zip:";
    public static final String FIXED_WIDTHS = "fixedWidths";
    public static final String FUNCTION = "function";

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        CsvConnection connection;
        CsvDriver.writeLog("CsvDriver:connect() - url=" + url);
        if (!url.startsWith(URL_PREFIX)) {
            return null;
        }
        String urlProperties = "";
        int questionIndex = url.indexOf(63);
        if (questionIndex >= 0) {
            info = new Properties(info);
            urlProperties = url.substring(questionIndex);
            String[] split = urlProperties.substring(1).split("&");
            for (int i = 0; i < split.length; ++i) {
                String[] property = split[i].split("=");
                try {
                    if (property.length != 2) {
                        throw new SQLException(CsvResources.getString("invalidProperty") + ": " + split[i]);
                    }
                    String key = URLDecoder.decode(property[0], "UTF-8");
                    String value = URLDecoder.decode(property[1], "UTF-8");
                    info.setProperty(key, value);
                    continue;
                }
                catch (UnsupportedEncodingException key) {
                    // empty catch block
                }
            }
            url = url.substring(0, questionIndex);
        }
        String filePath = url.substring(URL_PREFIX.length());
        CsvDriver.writeLog("CsvDriver:connect() - filePath=" + filePath);
        if (filePath.startsWith(READER_CLASS_PREFIX)) {
            String className = filePath.substring(READER_CLASS_PREFIX.length());
            try {
                Class<?> clazz = Class.forName(className);
                Class<?>[] interfaces = clazz.getInterfaces();
                boolean isInterfaceImplemented = false;
                for (int i = 0; i < interfaces.length && !isInterfaceImplemented; ++i) {
                    if (!interfaces[i].equals(TableReader.class)) continue;
                    isInterfaceImplemented = true;
                }
                if (!isInterfaceImplemented) {
                    throw new SQLException(CsvResources.getString("interfaceNotImplemented") + ": " + TableReader.class.getName() + ": " + className);
                }
                Object tableReaderInstance = clazz.newInstance();
                connection = new CsvConnection((TableReader)tableReaderInstance, info, urlProperties);
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(e);
            }
            catch (IllegalAccessException e) {
                throw new SQLException(e);
            }
            catch (InstantiationException e) {
                throw new SQLException(e);
            }
        } else if (filePath.startsWith(ZIP_FILE_PREFIX)) {
            String zipFilename = filePath.substring(ZIP_FILE_PREFIX.length());
            try {
                ZipFileTableReader zipFileTableReader = new ZipFileTableReader(zipFilename, info.getProperty(CHARSET));
                connection = new CsvConnection(zipFileTableReader, info, urlProperties);
                zipFileTableReader.setExtension(connection.getExtension());
            }
            catch (IOException e) {
                throw new SQLException(CsvResources.getString("zipOpenError") + ": " + zipFilename, e);
            }
        } else {
            File checkPath;
            if (!filePath.endsWith(File.separator)) {
                filePath = filePath + File.separator;
            }
            if (!(checkPath = new File(filePath)).exists()) {
                throw new SQLException(CsvResources.getString("dirNotFound") + ": " + filePath);
            }
            if (!checkPath.isDirectory()) {
                throw new SQLException(CsvResources.getString("dirNotFound") + ": " + filePath);
            }
            connection = new CsvConnection(filePath, info, urlProperties);
        }
        return connection;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        CsvDriver.writeLog("CsvDriver:accept() - url=" + url);
        return url.startsWith(URL_PREFIX);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException(CsvResources.getString("methodNotSupported") + ": Driver.getParentLogger()");
    }

    public static void writeLog(String message) {
        PrintWriter logWriter = DriverManager.getLogWriter();
        if (logWriter != null) {
            logWriter.println(CsvDriver.class.getPackage().getName() + ": " + message);
        }
    }

    public static void writeToCsv(ResultSet resultSet, PrintStream out, boolean writeHeaderLine) throws SQLException {
        int i;
        String separator = DEFAULT_SEPARATOR;
        Character quoteChar = Character.valueOf('\"');
        String quoteStyle = DEFAULT_QUOTE_STYLE;
        if (resultSet instanceof CsvResultSet) {
            CsvResultSet csvResultSet = (CsvResultSet)resultSet;
            CsvConnection csvConnection = (CsvConnection)csvResultSet.getStatement().getConnection();
            separator = csvConnection.getSeparator();
            quoteChar = csvConnection.getQuotechar();
            quoteStyle = csvConnection.getQuoteStyle();
        }
        ResultSetMetaData meta = null;
        int columnCount = 0;
        while (resultSet.next()) {
            if (meta == null) {
                meta = resultSet.getMetaData();
                columnCount = meta.getColumnCount();
                if (writeHeaderLine) {
                    for (i = 1; i <= columnCount; ++i) {
                        if (i > 1) {
                            out.print(separator);
                        }
                        out.print(meta.getColumnName(i));
                    }
                    out.println();
                }
            }
            for (i = 1; i <= columnCount; ++i) {
                String value;
                if (i > 1) {
                    out.print(separator);
                }
                if ((value = resultSet.getString(i)) == null) continue;
                if (quoteChar != null) {
                    value = CsvDriver.addQuotes(value, separator, quoteChar.charValue(), quoteStyle);
                }
                out.print(value);
            }
            out.println();
        }
        if (meta == null && writeHeaderLine) {
            meta = resultSet.getMetaData();
            columnCount = meta.getColumnCount();
            for (i = 1; i <= columnCount; ++i) {
                if (i > 1) {
                    out.print(separator);
                }
                out.print(meta.getColumnName(i));
            }
            out.println();
        }
        out.flush();
    }

    private static String addQuotes(String value, String separator, char quoteChar, String quoteStyle) {
        if (quoteStyle.equals("C")) {
            value = value.replace("\\", "\\\\");
            value = value.replace("" + quoteChar, "\\" + quoteChar);
        } else {
            value = value.replace("" + quoteChar, "" + quoteChar + quoteChar);
        }
        if (value.contains(separator) || value.indexOf(quoteChar) >= 0 || value.indexOf(13) >= 0 || value.indexOf(10) >= 0) {
            value = quoteChar + value + quoteChar;
        }
        return value;
    }

    static {
        try {
            DriverManager.registerDriver(new CsvDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(CsvResources.getString("initFailed") + ": " + e.getMessage());
        }
    }
}

