/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.Expression;
import org.xbib.jdbc.csv.LogicalExpression;
import org.xbib.jdbc.csv.RelopExpression;

class InExpression
extends LogicalExpression {
    Expression obj;
    List<Expression> inList;

    public InExpression(Expression obj, List<Expression> inList) {
        this.obj = obj;
        this.inList = inList;
    }

    @Override
    public boolean isTrue(Map<String, Object> env) throws SQLException {
        Comparable objValue = (Comparable)this.obj.eval(env);
        for (Expression expr : this.inList) {
            Comparable exprValue = (Comparable)expr.eval(env);
            Integer compared = RelopExpression.compare(objValue, exprValue, env);
            if (compared == null || compared != 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IN ");
        sb.append(this.obj.toString());
        sb.append(" (");
        String delimiter = "";
        for (Expression expr : this.inList) {
            sb.append(delimiter);
            sb.append(expr.toString());
            delimiter = ", ";
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.obj.usedColumns());
        for (Expression expr : this.inList) {
            result.addAll(expr.usedColumns());
        }
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        for (Expression expr : this.inList) {
            result.addAll(expr.aggregateFunctions());
        }
        return result;
    }
}

