/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class LikePattern {
    public static final String DEFAULT_ESCAPE_STRING = "\\";
    private static Hashtable<String, Pattern> compiledRegexs = new Hashtable();

    public static boolean matches(String likePattern, String escape, CharSequence input) {
        boolean retval;
        int percentIndex = likePattern.indexOf(37);
        int underscoreIndex = likePattern.indexOf(95);
        if (percentIndex < 0 && underscoreIndex < 0) {
            retval = likePattern.equals(input);
        } else {
            Pattern p = compiledRegexs.get(likePattern);
            if (p == null) {
                boolean isEscaped = false;
                StringBuilder regex = new StringBuilder();
                StringTokenizer tokenizer = new StringTokenizer(likePattern, "%_" + escape, true);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.equals(escape)) {
                        if (isEscaped) {
                            regex.append(Pattern.quote(token));
                            continue;
                        }
                        isEscaped = true;
                        continue;
                    }
                    if (isEscaped) {
                        regex.append(Pattern.quote(token));
                    } else if (token.equals("%")) {
                        regex.append(".*");
                    } else if (token.equals("_")) {
                        regex.append(".");
                    } else {
                        regex.append(Pattern.quote(token));
                    }
                    isEscaped = false;
                }
                p = Pattern.compile(regex.toString());
                compiledRegexs.put(likePattern, p);
            }
            retval = p.matcher(input).matches();
        }
        return retval;
    }
}

