/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.Expression;
import org.xbib.jdbc.csv.LogicalExpression;
import org.xbib.jdbc.csv.Placeholder;

class ParsedExpression
extends LogicalExpression {
    public Expression content;
    private Map<String, Object> placeholders;

    public ParsedExpression(Expression left) {
        this.content = left;
        this.placeholders = new HashMap<String, Object>();
    }

    @Override
    public boolean isValid() {
        return this.content.isValid();
    }

    @Override
    public boolean isTrue(Map<String, Object> env) throws SQLException {
        if (!this.placeholders.isEmpty()) {
            HashMap<String, Object> useThisEnv = new HashMap<String, Object>();
            useThisEnv.putAll(env);
            useThisEnv.putAll(this.placeholders);
            env = useThisEnv;
        }
        return ((LogicalExpression)this.content).isTrue(env);
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        if (!this.placeholders.isEmpty()) {
            HashMap<String, Object> useThisEnv = new HashMap<String, Object>();
            useThisEnv.putAll(env);
            useThisEnv.putAll(this.placeholders);
            env = useThisEnv;
        }
        return this.content.eval(env);
    }

    public String toString() {
        return this.content.toString();
    }

    @Override
    public List<String> usedColumns() {
        return this.content.usedColumns();
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        return this.content.aggregateFunctions();
    }

    public int getPlaceholdersCount() {
        return Placeholder.nextIndex - 1;
    }

    public void setPlaceholdersValues(Object[] values) {
        for (int i = 1; i < values.length; ++i) {
            this.placeholders.put("?" + i, values[i]);
        }
    }
}

