/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.ColumnName;
import org.xbib.jdbc.csv.Expression;
import org.xbib.jdbc.csv.LogicalExpression;
import org.xbib.jdbc.csv.StringConverter;

class RelopExpression
extends LogicalExpression {
    String op;
    Expression left;
    Expression right;
    boolean isValid;

    public RelopExpression(String op, Expression left, Expression right) {
        this.isValid = !(left instanceof LogicalExpression) && !(right instanceof LogicalExpression);
        this.op = op;
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean isTrue(Map<String, Object> env) throws SQLException {
        Comparable rightValue;
        boolean result = false;
        Comparable leftValue = (Comparable)this.left.eval(env);
        Integer leftComparedToRightObj = RelopExpression.compare(leftValue, rightValue = (Comparable)this.right.eval(env), env);
        if (leftComparedToRightObj != null) {
            int leftComparedToRight = leftComparedToRightObj;
            if (leftValue != null && rightValue != null) {
                switch (this.op) {
                    case "=": {
                        result = leftComparedToRight == 0;
                        break;
                    }
                    case "<>": 
                    case "!=": {
                        result = leftComparedToRight != 0;
                        break;
                    }
                    case ">": {
                        result = leftComparedToRight > 0;
                        break;
                    }
                    case "<": {
                        result = leftComparedToRight < 0;
                        break;
                    }
                    case "<=": 
                    case "=<": {
                        result = leftComparedToRight <= 0;
                        break;
                    }
                    case ">=": 
                    case "=>": {
                        result = leftComparedToRight >= 0;
                    }
                }
            }
        }
        return result;
    }

    public static Integer compare(Comparable leftValue, Comparable rightValue, Map<String, Object> env) throws SQLException {
        Integer leftComparedToRightObj = null;
        try {
            if (leftValue != null && rightValue != null) {
                leftComparedToRightObj = leftValue.compareTo(rightValue);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            if (leftComparedToRightObj == null && leftValue != null && rightValue != null) {
                if (leftValue instanceof Date) {
                    ColumnName stringConverter = new ColumnName("@STRINGCONVERTER");
                    StringConverter sc = (StringConverter)((Expression)stringConverter).eval(env);
                    Date date = sc.parseDate(rightValue.toString());
                    if (date != null) {
                        leftComparedToRightObj = leftValue.compareTo(date);
                    }
                } else if (rightValue instanceof Date) {
                    ColumnName stringConverter = new ColumnName("@STRINGCONVERTER");
                    StringConverter sc = (StringConverter)((Expression)stringConverter).eval(env);
                    Date date = sc.parseDate(leftValue.toString());
                    if (date != null) {
                        leftComparedToRightObj = date.compareTo((Date)rightValue);
                    }
                } else if (leftValue instanceof Time) {
                    ColumnName stringConverter = new ColumnName("@STRINGCONVERTER");
                    StringConverter sc = (StringConverter)((Expression)stringConverter).eval(env);
                    Time time = sc.parseTime(rightValue.toString());
                    if (time != null) {
                        leftComparedToRightObj = leftValue.compareTo(time);
                    }
                } else if (rightValue instanceof Time) {
                    ColumnName stringConverter = new ColumnName("@STRINGCONVERTER");
                    StringConverter sc = (StringConverter)((Expression)stringConverter).eval(env);
                    Time time = sc.parseTime(leftValue.toString());
                    if (time != null) {
                        leftComparedToRightObj = time.compareTo((Time)rightValue);
                    }
                } else if (leftValue instanceof Timestamp) {
                    ColumnName stringConverter = new ColumnName("@STRINGCONVERTER");
                    StringConverter sc = (StringConverter)((Expression)stringConverter).eval(env);
                    Timestamp timestamp = sc.parseTimestamp(rightValue.toString());
                    if (timestamp != null) {
                        leftComparedToRightObj = leftValue.compareTo(timestamp);
                    }
                } else if (rightValue instanceof Timestamp) {
                    ColumnName stringConverter = new ColumnName("@STRINGCONVERTER");
                    StringConverter sc = (StringConverter)((Expression)stringConverter).eval(env);
                    Timestamp timestamp = sc.parseTimestamp(leftValue.toString());
                    if (timestamp != null) {
                        leftComparedToRightObj = timestamp.compareTo((Timestamp)rightValue);
                    }
                } else if (leftValue instanceof Boolean) {
                    Boolean leftBoolean = (Boolean)leftValue;
                    Boolean rightBoolean = Boolean.valueOf(rightValue.toString());
                    leftComparedToRightObj = leftBoolean.equals(rightBoolean) ? Integer.valueOf(0) : (!leftBoolean.booleanValue() ? Integer.valueOf(-1) : Integer.valueOf(1));
                } else {
                    Double leftDouble = new Double(leftValue.toString());
                    Double rightDouble = new Double(rightValue.toString());
                    leftComparedToRightObj = leftDouble.compareTo(rightDouble);
                }
            }
        }
        catch (ClassCastException | NumberFormatException runtimeException) {
            // empty catch block
        }
        return leftComparedToRightObj;
    }

    public String toString() {
        return this.op + " " + this.left + " " + this.right;
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.left.usedColumns());
        result.addAll(this.right.usedColumns());
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.left.aggregateFunctions());
        result.addAll(this.right.aggregateFunctions());
        return result;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }
}

