/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.ColumnName;
import org.xbib.jdbc.csv.Expression;
import org.xbib.jdbc.csv.StringConverter;

class SQLCalendarFunction
extends Expression {
    String functionName;
    int calendarField;
    Expression expression;

    public SQLCalendarFunction(String functionName, int calendarField, Expression expression) {
        this.functionName = functionName;
        this.calendarField = calendarField;
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Integer retval = null;
        Object o = this.expression.eval(env);
        if (o != null) {
            Date date = null;
            if (o instanceof Date) {
                date = (Date)o;
            } else {
                ColumnName stringConverter = new ColumnName("@STRINGCONVERTER");
                StringConverter sc = (StringConverter)((Expression)stringConverter).eval(env);
                date = sc.parseTimestamp(o.toString());
                if (date == null) {
                    date = this.calendarField == 5 || this.calendarField == 2 || this.calendarField == 1 ? sc.parseDate(o.toString()) : sc.parseTime(o.toString());
                }
            }
            if (date != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                int fieldValue = cal.get(this.calendarField);
                if (this.calendarField == 2) {
                    ++fieldValue;
                }
                retval = fieldValue;
            }
        }
        return retval;
    }

    public String toString() {
        return this.functionName + "(" + this.expression + ")";
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.expression.usedColumns());
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.expression.aggregateFunctions());
        return result;
    }
}

