/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.Expression;

class SQLMinFunction
extends AggregateFunction {
    boolean isDistinct;
    Expression expression;
    Object min = null;

    public SQLMinFunction(boolean isDistinct, Expression expression) {
        this.isDistinct = isDistinct;
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Object o = env.get("@GROUPROWS");
        if (o != null) {
            List groupRows = (List)o;
            Object minInGroup = null;
            for (int i = 0; i < groupRows.size(); ++i) {
                o = this.expression.eval((Map)groupRows.get(i));
                if (o == null || minInGroup != null && ((Comparable)minInGroup).compareTo(o) <= 0) continue;
                minInGroup = o;
            }
            return minInGroup;
        }
        return this.min;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MIN(");
        if (this.isDistinct) {
            sb.append("DISTINCT ");
        }
        sb.append(this.expression);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<String> usedColumns() {
        return new LinkedList<String>();
    }

    @Override
    public List<String> aggregateColumns() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.expression.usedColumns());
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.add(this);
        return result;
    }

    @Override
    public void processRow(Map<String, Object> env) throws SQLException {
        Object o = this.expression.eval(env);
        if (o != null && (this.min == null || ((Comparable)this.min).compareTo(o) > 0)) {
            this.min = o;
        }
    }
}

