/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.Expression;
import org.xbib.jdbc.csv.RelopExpression;

class SQLNullIfFunction
extends Expression {
    Expression expression1;
    Expression expression2;

    public SQLNullIfFunction(Expression expression1, Expression expression2) {
        this.expression1 = expression1;
        this.expression2 = expression2;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Comparable value2;
        Comparable value1 = (Comparable)this.expression1.eval(env);
        Integer compared = RelopExpression.compare(value1, value2 = (Comparable)this.expression2.eval(env), env);
        Comparable retval = compared != null && compared == 0 ? null : value1;
        return retval;
    }

    public String toString() {
        return "NULLIF(" + this.expression1 + "," + this.expression2 + ")";
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.expression1.usedColumns());
        result.addAll(this.expression2.usedColumns());
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.expression1.aggregateFunctions());
        result.addAll(this.expression2.aggregateFunctions());
        return result;
    }
}

