/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.Expression;

class SQLSubstringFunction
extends Expression {
    private static final Integer MAX_LENGTH = Integer.MAX_VALUE;
    Expression expr;
    Expression startIndex;
    Expression len;

    public SQLSubstringFunction(Expression expr, Expression startIndex, Expression len) {
        this.expr = expr;
        this.startIndex = startIndex;
        this.len = len;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Object startIndexObj;
        Object retval = null;
        Object str = this.expr.eval(env);
        if (str != null && (startIndexObj = this.startIndex.eval(env)) != null) {
            if (this.len != null) {
                Object lenObj = this.len.eval(env);
                if (lenObj != null) {
                    retval = this.substring(str, startIndexObj, lenObj);
                }
            } else {
                retval = this.substring(str, startIndexObj, MAX_LENGTH);
            }
        }
        return retval;
    }

    private Object substring(Object str, Object startIndex, Object len) throws SQLException {
        int start = 0;
        long nChars = 0L;
        String retval = null;
        boolean parseIntFailed = false;
        if (startIndex instanceof Number) {
            start = ((Number)startIndex).intValue();
        } else {
            try {
                start = Integer.parseInt(startIndex.toString());
            }
            catch (NumberFormatException e) {
                parseIntFailed = true;
            }
        }
        if (len instanceof Number) {
            nChars = ((Number)len).intValue();
        } else {
            try {
                nChars = Integer.parseInt(len.toString());
            }
            catch (NumberFormatException e) {
                parseIntFailed = true;
            }
        }
        if (!parseIntFailed) {
            String s2;
            if (--start < 0) {
                nChars += (long)start;
                start = 0;
            }
            if (nChars < 0L) {
                nChars = 0L;
            }
            if (start >= (s2 = str.toString()).length()) {
                retval = "";
            } else {
                long endIndex = (long)start + nChars;
                if (endIndex > (long)s2.length()) {
                    endIndex = s2.length();
                }
                retval = s2.substring(start, (int)endIndex);
            }
        }
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SUBSTRING(");
        sb.append(this.expr);
        sb.append(",");
        sb.append(this.startIndex);
        if (this.len != null) {
            sb.append(",");
            sb.append(this.len);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.expr.usedColumns());
        result.addAll(this.startIndex.usedColumns());
        if (this.len != null) {
            result.addAll(this.len.usedColumns());
        }
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.expr.aggregateFunctions());
        result.addAll(this.startIndex.aggregateFunctions());
        if (this.len != null) {
            result.addAll(this.len.aggregateFunctions());
        }
        return result;
    }
}

