/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.Expression;

class SQLSumFunction
extends AggregateFunction {
    HashSet<Object> distinctValues;
    Expression expression;
    BigDecimal sum = null;
    int counter = 0;

    public SQLSumFunction(boolean isDistinct, Expression expression) {
        if (isDistinct) {
            this.distinctValues = new HashSet();
        }
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Number retval;
        block20: {
            retval = null;
            Object o = env.get("@GROUPROWS");
            if (o != null) {
                List groupRows = (List)o;
                BigDecimal groupSum = null;
                this.counter = 0;
                if (this.distinctValues != null) {
                    HashSet<Object> unique = new HashSet<Object>();
                    for (int i = 0; i < groupRows.size(); ++i) {
                        o = this.expression.eval((Map)groupRows.get(i));
                        if (o == null) continue;
                        unique.add(o);
                    }
                    for (Object e : unique) {
                        groupSum = groupSum == null ? new BigDecimal(e.toString()) : groupSum.add(new BigDecimal(e.toString()));
                        ++this.counter;
                    }
                } else {
                    for (int i = 0; i < groupRows.size(); ++i) {
                        o = this.expression.eval((Map)groupRows.get(i));
                        if (o == null) continue;
                        try {
                            groupSum = groupSum == null ? new BigDecimal(o.toString()) : groupSum.add(new BigDecimal(o.toString()));
                            ++this.counter;
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    if (groupSum != null) {
                        retval = groupSum.longValueExact();
                    }
                }
                catch (ArithmeticException e) {
                    retval = groupSum.doubleValue();
                }
                return retval;
            }
            try {
                if (this.distinctValues != null) {
                    BigDecimal groupSum = null;
                    for (Object obj : this.distinctValues) {
                        if (groupSum == null) {
                            groupSum = new BigDecimal(obj.toString());
                            continue;
                        }
                        groupSum = groupSum.add(new BigDecimal(obj.toString()));
                    }
                    this.counter = this.distinctValues.size();
                    try {
                        if (groupSum != null) {
                            retval = groupSum.longValueExact();
                        }
                        break block20;
                    }
                    catch (ArithmeticException e) {
                        retval = groupSum.doubleValue();
                    }
                    break block20;
                }
                if (this.sum != null) {
                    retval = this.sum.longValueExact();
                }
            }
            catch (ArithmeticException e) {
                retval = this.sum.doubleValue();
            }
        }
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SUM(");
        if (this.distinctValues != null) {
            sb.append("DISTINCT ");
        }
        sb.append(this.expression);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<String> usedColumns() {
        return new LinkedList<String>();
    }

    @Override
    public List<String> aggregateColumns() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.expression.usedColumns());
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.add(this);
        return result;
    }

    @Override
    public void processRow(Map<String, Object> env) throws SQLException {
        Object o = this.expression.eval(env);
        if (o != null) {
            try {
                this.sum = this.sum == null ? new BigDecimal(o.toString()) : this.sum.add(new BigDecimal(o.toString()));
                ++this.counter;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.distinctValues != null) {
                this.distinctValues.add(o);
            }
        }
    }
}

