/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.Expression;

class SQLTrimFunction
extends Expression {
    Expression expression;
    Expression trimChars;
    Type trimType;

    public SQLTrimFunction(Expression expression, Expression trimChars, Type trimType) {
        this.expression = expression;
        this.trimChars = trimChars;
        this.trimType = trimType;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Object retval = this.expression.eval(env);
        if (retval != null) {
            String str = retval.toString();
            if (this.trimChars != null) {
                Object o = this.trimChars.eval(env);
                if (o != null) {
                    int endIndex;
                    int startIndex;
                    String trim = o.toString();
                    if (this.trimType == Type.LEADING || this.trimType == Type.BOTH) {
                        for (startIndex = 0; startIndex < str.length() && trim.indexOf(str.charAt(startIndex)) >= 0; ++startIndex) {
                        }
                    }
                    if (this.trimType == Type.TRAILING || this.trimType == Type.BOTH) {
                        for (endIndex = str.length() - 1; endIndex >= startIndex && trim.indexOf(str.charAt(endIndex)) >= 0; --endIndex) {
                        }
                    }
                    retval = endIndex >= startIndex ? str.substring(startIndex, endIndex + 1) : "";
                } else {
                    retval = null;
                }
            } else if (this.trimType == Type.BOTH) {
                retval = str.trim();
            } else if (this.trimType == Type.LEADING) {
                int startIndex;
                for (startIndex = 0; startIndex < str.length() && Character.isWhitespace(str.charAt(startIndex)); ++startIndex) {
                }
                retval = str.substring(startIndex, str.length());
            } else {
                int endIndex;
                for (endIndex = str.length() - 1; endIndex >= 0 && Character.isWhitespace(str.charAt(endIndex)); --endIndex) {
                }
                retval = str.substring(0, endIndex + 1);
            }
        }
        return retval;
    }

    public String toString() {
        if (this.trimType == Type.LEADING) {
            return "LTRIM(" + this.expression + ")";
        }
        if (this.trimType == Type.TRAILING) {
            return "RTRIM(" + this.expression + ")";
        }
        return "TRIM(" + this.expression + ")";
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.expression.usedColumns());
        if (this.trimChars != null) {
            result.addAll(this.trimChars.usedColumns());
        }
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.expression.aggregateFunctions());
        if (this.trimChars != null) {
            result.addAll(this.trimChars.aggregateFunctions());
        }
        return result;
    }

    public static enum Type {
        LEADING,
        TRAILING,
        BOTH;

    }
}

