/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.CsvConnection;
import org.xbib.jdbc.csv.CsvResources;
import org.xbib.jdbc.csv.CsvStatement;
import org.xbib.jdbc.csv.Expression;
import org.xbib.jdbc.csv.StringConverter;

class SQLUserFunction
extends Expression {
    String name;
    List<Expression> expressions;

    public SQLUserFunction(String name, List<Expression> expressions) {
        this.name = name;
        this.expressions = expressions;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Object retval = null;
        CsvStatement statement = (CsvStatement)env.get("@STATEMENT");
        CsvConnection connection = (CsvConnection)statement.getConnection();
        Method method = connection.getSqlFunctions().get(this.name);
        if (method == null) {
            throw new SQLException(CsvResources.getString("noFunction") + ": " + this.name);
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        StringConverter converter = (StringConverter)env.get("@STRINGCONVERTER");
        boolean isVarArgs = method.isVarArgs();
        Object lastArg = null;
        if (isVarArgs && this.expressions.size() >= parameterTypes.length) {
            String parameterDataType = parameterTypes[parameterTypes.length - 1].getSimpleName();
            parameterDataType = parameterDataType.substring(0, parameterDataType.length() - 2);
            Class<?> parameterClass = this.getParameterClass(converter, parameterDataType);
            lastArg = Array.newInstance(parameterClass, this.expressions.size() - parameterTypes.length + 1);
        } else if (parameterTypes.length != this.expressions.size()) {
            throw new SQLException(CsvResources.getString("functionArgCount") + ": " + this.name);
        }
        Object[] args = new Object[parameterTypes.length];
        String parameterDataType = null;
        try {
            int i = 0;
            int varArgsIndex = 0;
            for (Expression expr : this.expressions) {
                Class<?> parameterClass;
                Object obj = expr.eval(env);
                if (obj == null) continue;
                parameterDataType = parameterTypes[i].getSimpleName();
                if (isVarArgs && i >= parameterTypes.length - 1) {
                    parameterClass = this.getParameterClass(converter, parameterDataType = parameterDataType.substring(0, parameterDataType.length() - 2));
                    if (parameterClass != Object.class) {
                        if (parameterClass == CharSequence.class) {
                            obj = obj.toString();
                        } else if (!parameterClass.equals(obj.getClass())) {
                            obj = converter.convert(parameterDataType, obj.toString());
                        }
                    }
                    Array.set(lastArg, varArgsIndex++, obj);
                    continue;
                }
                parameterClass = this.getParameterClass(converter, parameterDataType);
                if (parameterClass != Object.class) {
                    if (parameterClass == CharSequence.class) {
                        obj = obj.toString();
                    } else if (!parameterClass.equals(obj.getClass())) {
                        obj = converter.convert(parameterDataType, obj.toString());
                    }
                }
                args[i++] = obj;
            }
            if (isVarArgs) {
                args[args.length - 1] = lastArg;
            }
            retval = method.invoke(null, args);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(this.getInvokeString(args), e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(this.name + ": " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(this.getInvokeString(args), e);
        }
        return retval;
    }

    private Class<?> getParameterClass(StringConverter converter, String parameterDataType) throws SQLException {
        Class parameterClass = null;
        parameterClass = parameterDataType.equals(Object.class.getSimpleName()) ? Object.class : (parameterDataType.equals(CharSequence.class.getSimpleName()) ? CharSequence.class : converter.forSQLName(parameterDataType));
        if (parameterClass == null) {
            throw new SQLException(CsvResources.getString("functionArgClass") + ": " + parameterDataType);
        }
        return parameterClass;
    }

    public String getInvokeString(Object[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("(");
        String separator = "";
        for (Object o : args) {
            sb.append(separator);
            if (o != null) {
                sb.append(o.toString());
            } else {
                sb.append("null");
            }
            separator = ",";
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("(");
        String separator = "";
        for (Expression expression : this.expressions) {
            sb.append(separator);
            sb.append(expression.toString());
            separator = ", ";
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> result = new LinkedList<String>();
        for (Expression expression : this.expressions) {
            result.addAll(expression.usedColumns());
        }
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        for (Expression expression : this.expressions) {
            result.addAll(expression.aggregateFunctions());
        }
        return result;
    }
}

