/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.CsvResources;
import org.xbib.jdbc.csv.Expression;
import org.xbib.jdbc.csv.LogicalExpression;

class SearchedCaseExpression
extends Expression {
    private List<Expression> conditions;
    private List<Expression> values;
    private Expression elseExpression;

    public SearchedCaseExpression(List<Expression> conditions, List<Expression> values, Expression elseExpression) {
        this.conditions = conditions;
        this.values = values;
        this.elseExpression = elseExpression;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        for (int i = 0; i < this.conditions.size(); ++i) {
            Expression condition = this.conditions.get(i);
            if (!(condition instanceof LogicalExpression) || !condition.isValid()) {
                throw new SQLException(CsvResources.getString("caseNotLogical"));
            }
            if (!((LogicalExpression)condition).isTrue(env)) continue;
            return this.values.get(i).eval(env);
        }
        if (this.elseExpression != null) {
            return this.elseExpression.eval(env);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CASE");
        for (int i = 0; i < this.conditions.size(); ++i) {
            Expression condition = this.conditions.get(i);
            sb.append(" WHEN ").append(condition.toString()).append(" THEN ").append(this.values.get(i));
        }
        if (this.elseExpression != null) {
            sb.append(" ELSE ").append(this.elseExpression.toString());
        }
        sb.append(" END");
        return sb.toString();
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> result = new LinkedList<String>();
        Iterator<Expression> it = this.conditions.iterator();
        while (it.hasNext()) {
            result.addAll(it.next().usedColumns());
        }
        it = this.values.iterator();
        while (it.hasNext()) {
            result.addAll(it.next().usedColumns());
        }
        if (this.elseExpression != null) {
            result.addAll(this.elseExpression.usedColumns());
        }
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        Iterator<Expression> it = this.conditions.iterator();
        while (it.hasNext()) {
            result.addAll(it.next().aggregateFunctions());
        }
        it = this.values.iterator();
        while (it.hasNext()) {
            result.addAll(it.next().aggregateFunctions());
        }
        if (this.elseExpression != null) {
            result.addAll(this.elseExpression.aggregateFunctions());
        }
        return result;
    }
}

