/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.AggregateFunction;
import org.xbib.jdbc.csv.Expression;
import org.xbib.jdbc.csv.RelopExpression;

class SimpleCaseExpression
extends Expression {
    private Expression caseExpression;
    private List<Expression> switches;
    private List<Expression> values;
    private Expression elseExpression;

    public SimpleCaseExpression(Expression caseExpression, List<Expression> switches, List<Expression> values, Expression elseExpression) {
        this.caseExpression = caseExpression;
        this.switches = switches;
        this.values = values;
        this.elseExpression = elseExpression;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Object o1 = this.caseExpression.eval(env);
        for (int i = 0; i < this.switches.size(); ++i) {
            Expression expr = this.switches.get(i);
            Object o2 = expr.eval(env);
            Integer comparison = RelopExpression.compare((Comparable)o1, (Comparable)o2, env);
            if (comparison != 0) continue;
            return this.values.get(i).eval(env);
        }
        if (this.elseExpression != null) {
            return this.elseExpression.eval(env);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CASE ");
        sb.append(this.caseExpression.toString());
        for (int i = 0; i < this.switches.size(); ++i) {
            Expression expr = this.switches.get(i);
            sb.append(" WHEN ").append(expr.toString()).append(" THEN ").append(this.values.get(i));
        }
        if (this.elseExpression != null) {
            sb.append(" ELSE ").append(this.elseExpression.toString());
        }
        sb.append(" END");
        return sb.toString();
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.caseExpression.usedColumns());
        Iterator<Expression> it = this.switches.iterator();
        while (it.hasNext()) {
            result.addAll(it.next().usedColumns());
        }
        it = this.values.iterator();
        while (it.hasNext()) {
            result.addAll(it.next().usedColumns());
        }
        if (this.elseExpression != null) {
            result.addAll(this.elseExpression.usedColumns());
        }
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        Iterator<Expression> it = this.switches.iterator();
        while (it.hasNext()) {
            result.addAll(it.next().aggregateFunctions());
        }
        it = this.values.iterator();
        while (it.hasNext()) {
            result.addAll(it.next().aggregateFunctions());
        }
        if (this.elseExpression != null) {
            result.addAll(this.elseExpression.aggregateFunctions());
        }
        return result;
    }
}

