/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.csv;

import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xbib.jdbc.csv.CsvResources;
import org.xbib.jdbc.csv.Expression;
import org.xbib.jdbc.csv.ExpressionParser;
import org.xbib.jdbc.csv.LogicalExpression;
import org.xbib.jdbc.csv.OrderByEntry;
import org.xbib.jdbc.csv.ParseException;
import org.xbib.jdbc.csv.ParsedExpression;
import org.xbib.jdbc.csv.ParsedStatement;
import org.xbib.jdbc.csv.QueryEnvEntry;

public class SqlParser {
    private String tableName;
    private String tableAlias;
    private ParsedExpression whereClause;
    private List<Object[]> environment;
    private List<Expression> groupByColumns;
    private ParsedExpression havingClause;
    private List<Object[]> orderByColumns;
    private int limit;
    private int offset;
    private boolean isDistinct;

    public void setPlaceholdersValues(Object[] values) {
        if (this.whereClause != null) {
            this.whereClause.setPlaceholdersValues(values);
        }
    }

    public int getPlaceholdersCount() {
        if (this.whereClause != null) {
            return this.whereClause.getPlaceholdersCount();
        }
        return 0;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public List<Object[]> getColumns() {
        return this.environment;
    }

    public void parse(String sql) throws SQLException, ParseException {
        this.tableName = null;
        this.tableAlias = null;
        sql = sql + "\n";
        ExpressionParser cs2 = new ExpressionParser(new StringReader(sql));
        ParsedStatement parsedStatement = cs2.parseSingleStatement();
        this.setParsedStatement(parsedStatement);
    }

    public void setParsedStatement(ParsedStatement parsedStatement) throws SQLException {
        Expression cc;
        this.isDistinct = parsedStatement.isDistinct;
        if (!(parsedStatement.whereClause == null || parsedStatement.whereClause.content instanceof LogicalExpression && parsedStatement.whereClause.content.isValid())) {
            throw new SQLException(CsvResources.getString("whereNotLogical"));
        }
        this.whereClause = parsedStatement.whereClause;
        this.limit = parsedStatement.limit;
        this.offset = parsedStatement.offset;
        if (parsedStatement.tableEntries.size() > 1) {
            throw new SQLException(CsvResources.getString("joinNotSupported"));
        }
        if (parsedStatement.tableEntries.size() > 0) {
            this.tableName = parsedStatement.tableEntries.get(0).getTableName();
            this.tableAlias = parsedStatement.tableEntries.get(0).getTableAlias();
        }
        this.environment = new ArrayList<Object[]>();
        for (ParsedExpression parsedExpression : parsedStatement.queryEntries) {
            if (parsedExpression == null) continue;
            cc = (QueryEnvEntry)parsedExpression.content;
            if (cc.expression instanceof LogicalExpression || !cc.expression.isValid()) {
                throw new SQLException("invalidQueryExpression");
            }
            String key = cc.key;
            if (this.tableAlias != null && key.startsWith(this.tableAlias + ".")) {
                key = key.substring(this.tableAlias.length() + 1);
            }
            this.environment.add(new Object[]{key, cc.expression});
        }
        if (this.environment.isEmpty()) {
            throw new SQLException(CsvResources.getString("noColumnsSelected"));
        }
        Iterator<ParsedExpression> it2 = parsedStatement.groupByEntries.iterator();
        if (it2.hasNext()) {
            this.groupByColumns = new ArrayList<Expression>();
        }
        while (it2.hasNext()) {
            cc = it2.next();
            this.groupByColumns.add(((ParsedExpression)cc).content);
        }
        if (parsedStatement.havingClause != null && !(parsedStatement.havingClause.content instanceof LogicalExpression) && parsedStatement.havingClause.content.isValid()) {
            throw new SQLException(CsvResources.getString("havingNotLogical"));
        }
        this.havingClause = parsedStatement.havingClause;
        Iterator<ParsedExpression> it3 = parsedStatement.orderByEntries.iterator();
        if (it3.hasNext()) {
            this.orderByColumns = new ArrayList<Object[]>();
        }
        while (it3.hasNext()) {
            ParsedExpression cc2 = it3.next();
            OrderByEntry entry = (OrderByEntry)cc2.content;
            int direction = entry.order.equalsIgnoreCase("ASC") ? 1 : -1;
            this.orderByColumns.add(new Object[]{direction, entry.expression});
        }
    }

    public String[] getColumnNames() {
        String[] result = new String[this.environment.size()];
        for (int i = 0; i < this.environment.size(); ++i) {
            Object[] entry = this.environment.get(i);
            result[i] = (String)entry[0];
        }
        return result;
    }

    public LogicalExpression getWhereClause() {
        return this.whereClause;
    }

    public List<Expression> getGroupByColumns() {
        return this.groupByColumns;
    }

    public LogicalExpression getHavingClause() {
        return this.havingClause;
    }

    public List<Object[]> getOrderByColumns() {
        return this.orderByColumns;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getAlias(int i) {
        Object[] o = this.environment.get(i);
        return (String)o[0];
    }

    public Expression getExpression(int i) {
        Object[] o = this.environment.get(i);
        return (Expression)o[1];
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }
}

