/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.dbf;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xbib.jdbc.csv.CsvResources;
import org.xbib.jdbc.io.DataReader;

public class DbfReader
extends DataReader {
    private Object table = null;
    private List fields;
    private Integer recordCount;
    private Object record;
    private int rowNo;
    private Class<?> fieldClass;
    private Class<?> recordClass;
    private Class<?> tableClass;
    private Method tableOpenMethod;
    private Method tableGetFieldsMethod;
    private Method tableCloseMethod;
    private Method fieldGetNameMethod;
    private Method tableGetRecordCountMethod;
    private Method tableGetRecordAtMethod;
    private Method recordGetTypedValueMethod;
    private Method fieldGetTypeMethod;
    private Method fieldGetLengthMethod;
    private Map<String, String> dbfTypeToSQLType;
    private String tableAlias;

    public DbfReader(String path, String tableAlias, String charset) throws SQLException {
        try {
            this.fieldClass = Class.forName("nl.knaw.dans.common.dbflib.Field");
            this.recordClass = Class.forName("nl.knaw.dans.common.dbflib.Record");
            this.tableClass = Class.forName("nl.knaw.dans.common.dbflib.Table");
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(CsvResources.getString("noDansDbf") + ": " + e);
        }
        try {
            this.tableOpenMethod = this.tableClass.getMethod("open", new Class[0]);
            this.tableCloseMethod = this.tableClass.getMethod("close", new Class[0]);
            this.tableGetFieldsMethod = this.tableClass.getMethod("getFields", new Class[0]);
            this.fieldGetNameMethod = this.fieldClass.getMethod("getName", new Class[0]);
            this.tableGetRecordCountMethod = this.tableClass.getMethod("getRecordCount", new Class[0]);
            this.tableGetRecordAtMethod = this.tableClass.getMethod("getRecordAt", Integer.TYPE);
            this.recordGetTypedValueMethod = this.recordClass.getMethod("getTypedValue", String.class);
            this.fieldGetTypeMethod = this.fieldClass.getMethod("getType", new Class[0]);
            this.fieldGetLengthMethod = this.fieldClass.getMethod("getLength", new Class[0]);
        }
        catch (Exception e) {
            throw new SQLException(CsvResources.getString("dansDbfError") + ": " + e);
        }
        try {
            if (charset != null) {
                Constructor<?> tableConstructor = this.tableClass.getConstructor(File.class, String.class);
                this.table = tableConstructor.newInstance(new File(path), charset);
            } else {
                Constructor<?> tableConstructor = this.tableClass.getConstructor(File.class);
                this.table = tableConstructor.newInstance(new File(path));
            }
            this.tableOpenMethod.invoke(this.table, new Object[0]);
            this.fields = (List)this.tableGetFieldsMethod.invoke(this.table, new Object[0]);
            this.recordCount = (Integer)this.tableGetRecordCountMethod.invoke(this.table, new Object[0]);
            this.record = null;
            this.rowNo = -1;
            this.tableAlias = tableAlias;
        }
        catch (Exception e) {
            throw new SQLException(CsvResources.getString("dansDbfError") + ": " + e);
        }
        this.dbfTypeToSQLType = new HashMap<String, String>();
        this.dbfTypeToSQLType.put("CHARACTER", "String");
        this.dbfTypeToSQLType.put("NUMBER", "Double");
        this.dbfTypeToSQLType.put("LOGICAL", "Boolean");
        this.dbfTypeToSQLType.put("DATE", "Date");
        this.dbfTypeToSQLType.put("MEMO", "String");
        this.dbfTypeToSQLType.put("FLOAT", "Double");
    }

    @Override
    public void close() throws SQLException {
        if (this.table != null) {
            try {
                this.tableCloseMethod.invoke(this.table, new Object[0]);
            }
            catch (Exception e) {
                throw new SQLException(CsvResources.getString("dansDbfError") + ": " + e);
            }
        }
        this.table = null;
    }

    @Override
    public String[] getColumnNames() throws SQLException {
        int columnCount = this.fields.size();
        String[] result = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            Object field = this.fields.get(i);
            try {
                result[i] = (String)this.fieldGetNameMethod.invoke(field, new Object[0]);
                continue;
            }
            catch (Exception e) {
                throw new SQLException(CsvResources.getString("dansDbfError") + ": " + e);
            }
        }
        return result;
    }

    @Override
    public Object getField(int i) throws SQLException {
        Object field = this.fields.get(i - 1);
        try {
            String fieldName = (String)this.fieldGetNameMethod.invoke(field, new Object[0]);
            Object result = this.recordGetTypedValueMethod.invoke(this.record, fieldName);
            if (result instanceof String) {
                result = ((String)result).trim();
            } else if (result instanceof Date) {
                result = new java.sql.Date(((Date)result).getTime());
            }
            return result;
        }
        catch (Exception e) {
            throw new SQLException(CsvResources.getString("dansDbfError") + ": " + e);
        }
    }

    @Override
    public boolean next() throws SQLException {
        ++this.rowNo;
        if (this.rowNo >= this.recordCount) {
            return false;
        }
        try {
            this.record = this.tableGetRecordAtMethod.invoke(this.table, this.rowNo);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e.getCause());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String[] getColumnTypes() throws SQLException {
        String[] result = new String[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            String dbfType = "";
            try {
                dbfType = this.fieldGetTypeMethod.invoke(this.fields.get(i), new Object[0]).toString();
            }
            catch (Exception e) {
                throw new SQLException(CsvResources.getString("dansDbfError") + ": " + e);
            }
            result[i] = this.dbfTypeToSQLType.get(dbfType);
            if (result[i] != null) continue;
            throw new SQLException(CsvResources.getString("dbfTypeNotSupported") + ": " + dbfType);
        }
        return result;
    }

    @Override
    public int[] getColumnSizes() throws SQLException {
        int[] result = new int[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            try {
                Object fieldLength = this.fieldGetLengthMethod.invoke(this.fields.get(i), new Object[0]);
                result[i] = ((Number)fieldLength).intValue();
                continue;
            }
            catch (Exception e) {
                throw new SQLException(CsvResources.getString("dansDbfError") + ": " + e);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> getEnvironment() throws SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < this.fields.size(); ++i) {
            Object field = this.fields.get(i);
            try {
                String fieldName = (String)this.fieldGetNameMethod.invoke(field, new Object[0]);
                Object o = this.getField(i + 1);
                fieldName = fieldName.toUpperCase();
                result.put(fieldName, o);
                if (this.tableAlias == null) continue;
                result.put(this.tableAlias + "." + fieldName, o);
                continue;
            }
            catch (Exception e) {
                throw new SQLException(CsvResources.getString("dansDbfError") + ": " + e);
            }
        }
        return result;
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }
}

