/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.io;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.xbib.jdbc.io.CryptoFilter;

public class EncryptedFileInputStream
extends InputStream {
    private final InputStream in;
    private final CryptoFilter filter;

    public EncryptedFileInputStream(String fileName, CryptoFilter filter) throws FileNotFoundException {
        this.filter = filter;
        this.in = new BufferedInputStream(new FileInputStream(fileName));
    }

    @Override
    public int read() throws IOException {
        if (this.filter != null) {
            return this.filter.read(this.in);
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.filter != null) {
            return this.filter.read(this.in, b, off, len);
        }
        return this.in.read(b, off, len);
    }

    public int read(InputStream in, byte[] b) throws IOException {
        if (this.filter != null) {
            return this.filter.read(in, b);
        }
        return in.read(b);
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
    }
}

