/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.jdbc.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbib.jdbc.csv.CsvResources;
import org.xbib.jdbc.io.CryptoFilter;
import org.xbib.jdbc.io.EncryptedFileInputStream;

public class FileSetInputStream
extends InputStream {
    private String dirName;
    private List<String> fileNames;
    private EncryptedFileInputStream currentFile;
    private boolean readingHeader;
    private String tail;
    private int pos;
    private Pattern fileNameRE;
    private String separator;
    private String dataTail;
    private boolean prepend;
    private int lookahead = 10;
    private boolean doingTail;
    private int currentLineLength;
    private CryptoFilter filter;
    private int skipLeadingDataLines;
    private boolean isClosed = false;

    public FileSetInputStream(String dirName, String fileNamePattern, String[] fieldsInName, String separator, boolean prepend, boolean headerless, CryptoFilter filter, int skipLeadingDataLines) throws IOException {
        this.dirName = dirName;
        this.filter = filter;
        this.skipLeadingDataLines = skipLeadingDataLines;
        if (!headerless) {
            ++this.skipLeadingDataLines;
        }
        this.prepend = prepend;
        this.separator = separator;
        this.tail = "";
        if (prepend) {
            this.tail = this.tail + '\n';
        } else if (fieldsInName != null) {
            this.tail = this.tail + separator;
        }
        if (fieldsInName != null) {
            for (int i = 0; i < fieldsInName.length; ++i) {
                this.tail = this.tail + fieldsInName[i];
                if (i + 1 >= fieldsInName.length) continue;
                this.tail = this.tail + separator;
            }
        }
        if (prepend) {
            if (fieldsInName != null) {
                this.tail = this.tail + separator;
            }
        } else {
            this.tail = this.tail + '\n';
        }
        this.fileNames = new ArrayList<String>();
        File root = new File(dirName);
        String[] candidates = root.list();
        this.fileNameRE = Pattern.compile(fileNamePattern);
        for (int i = 0; i < candidates.length; ++i) {
            Matcher m = this.fileNameRE.matcher(candidates[i]);
            if (!m.matches()) continue;
            this.fileNames.add(candidates[i]);
        }
        Collections.sort(this.fileNames);
        if (this.fileNames.isEmpty()) {
            return;
        }
        this.fileNameRE = Pattern.compile(".*" + fileNamePattern);
        this.readingHeader = true;
        String currentFileName = this.fileNames.remove(0);
        this.dataTail = this.getTailFromName(dirName + currentFileName);
        if (headerless) {
            this.tail = this.dataTail;
        }
        this.currentFile = new EncryptedFileInputStream(dirName + currentFileName, filter);
        this.lookahead = this.currentFile.read();
        this.doingTail = prepend;
        if (this.doingTail) {
            this.pos = 1;
        }
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        if (this.currentFile != null) {
            this.currentFile.close();
            this.currentFile = null;
        }
    }

    @Override
    public int read() throws IOException {
        int ch;
        if (this.isClosed) {
            throw new IOException(CsvResources.getString("streamClosed"));
        }
        if (this.currentFile == null) {
            return -1;
        }
        if (this.doingTail) {
            ch = this.readFromTail();
            if (ch != -1) {
                return ch;
            }
            this.doingTail = false;
            this.currentLineLength = 0;
        }
        ch = this.lookahead;
        do {
            this.lookahead = this.currentFile.read();
        } while (this.lookahead == 13);
        if (this.prepend) {
            if (ch == 10 && this.lookahead != 10 && this.lookahead != -1) {
                this.doingTail = true;
                return this.readFromTail();
            }
        } else if (this.currentLineLength > 0 && (ch == 10 || ch == -1)) {
            this.doingTail = true;
            return this.readFromTail();
        }
        if (ch < 0) {
            this.currentFile.close();
            this.pos = 0;
            if (this.fileNames.size() <= 0) {
                this.currentFile = null;
                return -1;
            }
            String currentFileName = this.fileNames.remove(0);
            this.tail = this.getTailFromName(this.dirName + currentFileName);
            this.currentFile = new EncryptedFileInputStream(this.dirName + currentFileName, this.filter);
            for (int i = 0; i < this.skipLeadingDataLines; ++i) {
                int ch2;
                while ((ch2 = this.currentFile.read()) != 10 && ch2 != -1) {
                }
            }
            this.doingTail = this.prepend;
            if (this.doingTail) {
                this.pos = 1;
            }
            this.lookahead = this.currentFile.read();
            return this.read();
        }
        ++this.currentLineLength;
        return ch;
    }

    private String getTailFromName(String currentName) {
        Matcher m = this.fileNameRE.matcher(currentName);
        m.matches();
        String tail = "";
        int groupCount = m.groupCount();
        if (this.prepend) {
            tail = tail + '\n';
        } else if (groupCount > 0) {
            tail = tail + this.separator;
        }
        for (int i = 1; i <= groupCount; ++i) {
            tail = tail + m.group(i);
            if (i >= groupCount) continue;
            tail = tail + this.separator;
        }
        if (this.prepend) {
            if (groupCount > 0) {
                tail = tail + this.separator;
            }
        } else {
            tail = tail + '\n';
        }
        return tail;
    }

    private int readFromTail() {
        if (this.pos < this.tail.length()) {
            return this.tail.charAt(this.pos++);
        }
        this.pos = 0;
        if (this.readingHeader) {
            this.readingHeader = false;
            this.tail = this.dataTail;
        }
        return -1;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
    }
}

