/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.MediaTypeQuery;

public final class BodyFilters {
    BodyFilters() {
    }

    public static BodyFilter defaultValue() {
        return BodyFilters.accessToken();
    }

    public static BodyFilter accessToken() {
        HashSet<String> properties = new HashSet<String>();
        properties.add("access_token");
        properties.add("open_id");
        properties.add("id_token");
        return BodyFilters.replaceJsonStringProperty(properties, "XXX");
    }

    public static BodyFilter replaceJsonStringProperty(Set<String> properties, String replacement) {
        String regex = properties.stream().map(Pattern::quote).collect(Collectors.joining("|"));
        Predicate<String> json = MediaTypeQuery.compile("application/json", "application/*+json");
        Pattern pattern = Pattern.compile("(\"(?:" + regex + ")\"\\s*\\:\\s*)\".+?\"");
        return (contentType, body) -> json.test(contentType) ? pattern.matcher(body).replaceAll("$1\"" + replacement + "\"") : body;
    }
}

