/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.zalando.logbook.BaseHttpMessage;
import org.zalando.logbook.BaseHttpRequest;
import org.zalando.logbook.Glob;
import org.zalando.logbook.MediaTypeQuery;
import org.zalando.logbook.RequestURI;

public final class Conditions {
    Conditions() {
    }

    @SafeVarargs
    public static <T extends BaseHttpMessage> Predicate<T> exclude(Predicate<T> ... predicates) {
        return Conditions.exclude(Arrays.asList(predicates));
    }

    public static <T extends BaseHttpMessage> Predicate<T> exclude(Collection<Predicate<T>> predicates) {
        return predicates.stream().map(Predicate::negate).reduce(Predicate::and).orElse($ -> true);
    }

    public static <T extends BaseHttpRequest> Predicate<T> requestTo(String pattern) {
        Predicate<String> predicate = Glob.compile(pattern);
        return pattern.startsWith("/") ? Conditions.requestTo(BaseHttpRequest::getPath, predicate) : Conditions.requestTo(request -> RequestURI.reconstruct((BaseHttpRequest)request, (RequestURI.Component[])new RequestURI.Component[]{RequestURI.Component.SCHEME, RequestURI.Component.AUTHORITY, RequestURI.Component.PATH}), predicate);
    }

    private static <T extends BaseHttpRequest> Predicate<T> requestTo(Function<BaseHttpRequest, String> extractor, Predicate<String> predicate) {
        return request -> predicate.test((String)extractor.apply((BaseHttpRequest)request));
    }

    public static <T extends BaseHttpMessage> Predicate<T> contentType(String ... contentTypes) {
        Predicate<String> query = MediaTypeQuery.compile(contentTypes);
        return message -> query.test(message.getContentType());
    }

    public static <T extends BaseHttpMessage> Predicate<T> header(String key, String value) {
        return message -> message.getHeaders().getOrDefault(key, Collections.emptyList()).contains(value);
    }

    public static <T extends BaseHttpMessage> Predicate<T> header(String key, Predicate<String> predicate) {
        return message -> ((List)message.getHeaders().get(key)).stream().anyMatch(predicate);
    }

    public static <T extends BaseHttpMessage> Predicate<T> header(BiPredicate<String, String> predicate) {
        return message -> message.getHeaders().entrySet().stream().anyMatch(e -> ((List)e.getValue()).stream().anyMatch(v -> predicate.test((String)e.getKey(), (String)v)));
    }
}

