/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.DefaultHttpLogFormatter;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Precorrelation;

public final class CurlHttpLogFormatter
implements HttpLogFormatter {
    private final HttpLogFormatter fallback;

    public CurlHttpLogFormatter() {
        this(new DefaultHttpLogFormatter());
    }

    public CurlHttpLogFormatter(HttpLogFormatter fallback) {
        this.fallback = fallback;
    }

    public String format(Precorrelation<HttpRequest> precorrelation) throws IOException {
        HttpRequest request = (HttpRequest)precorrelation.getRequest();
        ArrayList<String> command = new ArrayList<String>();
        command.add("curl");
        command.add("-v");
        command.add("-X");
        command.add(request.getMethod());
        command.add(CurlHttpLogFormatter.quote(request.getRequestUri()));
        request.getHeaders().forEach((header, values) -> values.forEach(value -> {
            command.add("-H");
            command.add(CurlHttpLogFormatter.quote(header + ": " + value));
        }));
        String body = request.getBodyAsString();
        if (!body.isEmpty()) {
            command.add("--data-binary");
            command.add(CurlHttpLogFormatter.quote(body));
        }
        return command.stream().collect(Collectors.joining(" "));
    }

    private static String quote(String s) {
        return "'" + CurlHttpLogFormatter.escape(s) + "'";
    }

    private static String escape(String s) {
        return s.replace("'", "\\'");
    }

    public String format(Correlation<HttpRequest, HttpResponse> correlation) throws IOException {
        return this.fallback.format(correlation);
    }
}

