/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.Correlator;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpLogWriter;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.RawHttpResponse;
import org.zalando.logbook.RawRequestFilter;
import org.zalando.logbook.RawResponseFilter;
import org.zalando.logbook.RequestFilter;
import org.zalando.logbook.ResponseFilter;

final class DefaultLogbook
implements Logbook {
    private final Predicate<RawHttpRequest> predicate;
    private final RawRequestFilter rawRequestFilter;
    private final RawResponseFilter rawResponseFilter;
    private final RequestFilter requestFilter;
    private final ResponseFilter responseFilter;
    private final HttpLogFormatter formatter;
    private final HttpLogWriter writer;

    DefaultLogbook(Predicate<RawHttpRequest> predicate, RawRequestFilter rawRequestFilter, RawResponseFilter rawResponseFilter, RequestFilter requestFilter, ResponseFilter responseFilter, HttpLogFormatter formatter, HttpLogWriter writer) {
        this.predicate = predicate;
        this.rawRequestFilter = rawRequestFilter;
        this.rawResponseFilter = rawResponseFilter;
        this.requestFilter = requestFilter;
        this.responseFilter = responseFilter;
        this.formatter = formatter;
        this.writer = writer;
    }

    public Optional<Correlator> write(RawHttpRequest rawHttpRequest) throws IOException {
        if (this.writer.isActive(rawHttpRequest) && this.predicate.test(rawHttpRequest)) {
            String correlationId = UUID.randomUUID().toString();
            RawHttpRequest filteredRawHttpRequest = this.rawRequestFilter.filter(rawHttpRequest);
            HttpRequest request = this.requestFilter.filter(filteredRawHttpRequest.withBody());
            SimplePrecorrelation<HttpRequest> precorrelation = new SimplePrecorrelation<HttpRequest>(correlationId, request);
            String format = this.formatter.format(precorrelation);
            this.writer.writeRequest(new SimplePrecorrelation<String>(correlationId, format));
            return Optional.of(rawHttpResponse -> {
                RawHttpResponse filteredRawHttpResponse = this.rawResponseFilter.filter(rawHttpResponse);
                HttpResponse response = this.responseFilter.filter(filteredRawHttpResponse.withBody());
                SimpleCorrelation<HttpRequest, HttpResponse> correlation = new SimpleCorrelation<HttpRequest, HttpResponse>(correlationId, request, response);
                String message = this.formatter.format(correlation);
                this.writer.writeResponse(new SimpleCorrelation<String, String>(correlationId, format, message));
            });
        }
        return Optional.empty();
    }

    static class SimpleCorrelation<I, O>
    implements Correlation<I, O> {
        private final String id;
        private final I request;
        private final O response;

        public SimpleCorrelation(String id, I request, O response) {
            this.id = id;
            this.request = request;
            this.response = response;
        }

        public String getId() {
            return this.id;
        }

        public I getRequest() {
            return this.request;
        }

        public O getResponse() {
            return this.response;
        }
    }

    static class SimplePrecorrelation<I>
    implements Precorrelation<I> {
        private final String id;
        private final I request;

        public SimplePrecorrelation(String id, I request) {
            this.id = id;
            this.request = request;
        }

        public String getId() {
            return this.id;
        }

        public I getRequest() {
            return this.request;
        }
    }
}

