/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.MediaTypeQuery;
import org.zalando.logbook.Origin;
import org.zalando.logbook.Precorrelation;

public final class JsonHttpLogFormatter
implements HttpLogFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonHttpLogFormatter.class);
    private static final Predicate<String> JSON = MediaTypeQuery.compile("application/json", "application/*+json");
    private final ObjectMapper mapper;

    public JsonHttpLogFormatter() {
        this(new ObjectMapper());
    }

    public JsonHttpLogFormatter(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public String format(Precorrelation<HttpRequest> precorrelation) throws IOException {
        return this.format(this.prepare(precorrelation));
    }

    public Map<String, Object> prepare(Precorrelation<HttpRequest> precorrelation) throws IOException {
        String correlationId = precorrelation.getId();
        HttpRequest request = (HttpRequest)precorrelation.getRequest();
        LinkedHashMap<String, Object> content = new LinkedHashMap<String, Object>();
        content.put("origin", JsonHttpLogFormatter.translate(request.getOrigin()));
        content.put("type", "request");
        content.put("correlation", correlationId);
        content.put("protocol", request.getProtocolVersion());
        content.put("remote", request.getRemote());
        content.put("method", request.getMethod());
        content.put("uri", request.getRequestUri());
        JsonHttpLogFormatter.addUnless(content, "headers", request.getHeaders(), Map::isEmpty);
        this.addBody((HttpMessage)request, content);
        return content;
    }

    public String format(Correlation<HttpRequest, HttpResponse> correlation) throws IOException {
        return this.format(this.prepare(correlation));
    }

    public Map<String, Object> prepare(Correlation<HttpRequest, HttpResponse> correlation) throws IOException {
        String correlationId = correlation.getId();
        HttpResponse response = (HttpResponse)correlation.getResponse();
        LinkedHashMap<String, Object> content = new LinkedHashMap<String, Object>();
        content.put("origin", JsonHttpLogFormatter.translate(response.getOrigin()));
        content.put("type", "response");
        content.put("correlation", correlationId);
        content.put("protocol", response.getProtocolVersion());
        content.put("status", response.getStatus());
        JsonHttpLogFormatter.addUnless(content, "headers", response.getHeaders(), Map::isEmpty);
        this.addBody((HttpMessage)response, content);
        return content;
    }

    private static String translate(Origin origin) {
        return origin.name().toLowerCase(Locale.ROOT);
    }

    private static <T> void addUnless(Map<String, Object> target, String key, T element, Predicate<T> predicate) {
        if (!predicate.test(element)) {
            target.put(key, element);
        }
    }

    private void addBody(HttpMessage message, Map<String, Object> map) throws IOException {
        String body = message.getBodyAsString();
        if (this.isJson(message.getContentType())) {
            map.put("body", this.tryParseBodyAsJson(body));
        } else {
            JsonHttpLogFormatter.addUnless(map, "body", body, String::isEmpty);
        }
    }

    private Object tryParseBodyAsJson(String body) {
        if (body.isEmpty()) {
            return "";
        }
        try {
            return new JsonBody(this.compactJson(body));
        }
        catch (IOException e) {
            LOG.trace("Unable to parse body as JSON; embedding it as-is: [{}]", (Object)e.getMessage());
            return body;
        }
    }

    private boolean isJson(@Nullable String type) {
        return JSON.test(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String compactJson(String json) throws IOException {
        if (this.isAlreadyCompacted(json)) {
            return json;
        }
        StringWriter output = new StringWriter();
        JsonFactory factory = this.mapper.getFactory();
        JsonParser parser = factory.createParser(json);
        try (JsonGenerator generator = factory.createGenerator((Writer)output);){
            while (parser.nextToken() != null) {
                generator.copyCurrentEvent(parser);
            }
        }
        return output.toString();
    }

    private boolean isAlreadyCompacted(String json) {
        return json.indexOf(10) == -1;
    }

    public String format(Map<String, Object> content) throws IOException {
        return this.mapper.writeValueAsString(content);
    }

    private static final class JsonBody {
        static final String EMPTY = "";
        private final String json;

        private JsonBody(String json) {
            this.json = json;
        }

        @JsonRawValue
        @JsonValue
        public String getJson() {
            return this.json;
        }
    }
}

