/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Predicate;
import lombok.Generated;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.CorrelationId;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.RequestFilter;
import org.zalando.logbook.ResponseFilter;
import org.zalando.logbook.Sink;
import org.zalando.logbook.Strategy;
import org.zalando.logbook.core.CachingHttpRequest;
import org.zalando.logbook.core.CachingHttpResponse;
import org.zalando.logbook.core.Stages;

final class DefaultLogbook
implements Logbook {
    private final Predicate<HttpRequest> predicate;
    private final CorrelationId correlationId;
    private final RequestFilter requestFilter;
    private final ResponseFilter responseFilter;
    private final Strategy strategy;
    private final Sink sink;
    private final Clock clock = Clock.systemUTC();

    public Logbook.RequestWritingStage process(HttpRequest originalRequest) throws IOException {
        return this.process(originalRequest, this.strategy);
    }

    public Logbook.RequestWritingStage process(HttpRequest originalRequest, final Strategy strategy) throws IOException {
        if (this.sink.isActive() && this.predicate.test(originalRequest)) {
            final Precorrelation precorrelation = this.newPrecorrelation(originalRequest);
            HttpRequest processedRequest = strategy.process(originalRequest);
            CachingHttpRequest request = new CachingHttpRequest(processedRequest);
            final HttpRequest filteredRequest = this.requestFilter.filter((HttpRequest)request);
            return new Logbook.RequestWritingStage(){

                public Logbook.ResponseProcessingStage write() throws IOException {
                    strategy.write(precorrelation, filteredRequest, DefaultLogbook.this.sink);
                    return this;
                }

                public Logbook.ResponseWritingStage process(HttpResponse originalResponse) throws IOException {
                    HttpResponse processedResponse = strategy.process(filteredRequest, originalResponse);
                    return () -> {
                        CachingHttpResponse response = new CachingHttpResponse(processedResponse);
                        HttpResponse filteredResponse = DefaultLogbook.this.responseFilter.filter((HttpResponse)response);
                        strategy.write(precorrelation.correlate(), filteredRequest, filteredResponse, DefaultLogbook.this.sink);
                    };
                }
            };
        }
        return Stages.noop();
    }

    private Precorrelation newPrecorrelation(HttpRequest request) {
        return new SimplePrecorrelation(this.correlationId.generate(request), this.clock);
    }

    @Generated
    public DefaultLogbook(Predicate<HttpRequest> predicate, CorrelationId correlationId, RequestFilter requestFilter, ResponseFilter responseFilter, Strategy strategy, Sink sink) {
        this.predicate = predicate;
        this.correlationId = correlationId;
        this.requestFilter = requestFilter;
        this.responseFilter = responseFilter;
        this.strategy = strategy;
        this.sink = sink;
    }

    static final class SimplePrecorrelation
    implements Precorrelation {
        private final String id;
        private final Clock clock;
        private final Instant start;

        SimplePrecorrelation(String id, Clock clock) {
            this.id = id;
            this.clock = clock;
            this.start = Instant.now(clock);
        }

        public Correlation correlate() {
            return new SimpleCorrelation(this.id, this.start, Instant.now(this.clock));
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public Instant getStart() {
            return this.start;
        }
    }

    static final class SimpleCorrelation
    implements Correlation {
        private final String id;
        private final Instant start;
        private final Instant end;
        private final Duration duration;

        SimpleCorrelation(String id, Instant start, Instant end) {
            this(id, start, end, Duration.between(start, end));
        }

        @Generated
        private SimpleCorrelation(String id, Instant start, Instant end, Duration duration) {
            this.id = id;
            this.start = start;
            this.end = end;
            this.duration = duration;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public Instant getStart() {
            return this.start;
        }

        @Generated
        public Instant getEnd() {
            return this.end;
        }

        @Generated
        public Duration getDuration() {
            return this.duration;
        }
    }
}

