/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.CorrelationId;
import org.zalando.logbook.HeaderFilter;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.LogbookFactory;
import org.zalando.logbook.PathFilter;
import org.zalando.logbook.QueryFilter;
import org.zalando.logbook.RequestFilter;
import org.zalando.logbook.ResponseFilter;
import org.zalando.logbook.Sink;
import org.zalando.logbook.Strategy;
import org.zalando.logbook.core.BodyFilters;
import org.zalando.logbook.core.DefaultCorrelationId;
import org.zalando.logbook.core.DefaultHttpLogFormatter;
import org.zalando.logbook.core.DefaultHttpLogWriter;
import org.zalando.logbook.core.DefaultLogbook;
import org.zalando.logbook.core.DefaultSink;
import org.zalando.logbook.core.DefaultStrategy;
import org.zalando.logbook.core.FilteredHttpRequest;
import org.zalando.logbook.core.FilteredHttpResponse;
import org.zalando.logbook.core.HeaderFilters;
import org.zalando.logbook.core.PathFilters;
import org.zalando.logbook.core.QueryFilters;
import org.zalando.logbook.core.RequestFilters;
import org.zalando.logbook.core.ResponseFilters;

@API(status=API.Status.INTERNAL)
public final class DefaultLogbookFactory
implements LogbookFactory {
    public Logbook create(@Nullable Predicate<HttpRequest> condition, @Nullable CorrelationId correlationId, @Nullable QueryFilter queryFilter, @Nullable PathFilter pathFilter, @Nullable HeaderFilter headerFilter, @Nullable BodyFilter bodyFilter, @Nullable RequestFilter requestFilter, @Nullable ResponseFilter responseFilter, @Nullable Strategy strategy, @Nullable Sink sink) {
        HeaderFilter header = Optional.ofNullable(headerFilter).orElseGet(HeaderFilters::defaultValue);
        BodyFilter body = Optional.ofNullable(bodyFilter).orElseGet(BodyFilters::defaultValue);
        return new DefaultLogbook(Optional.ofNullable(condition).orElse($ -> true), Optional.ofNullable(correlationId).orElseGet(DefaultCorrelationId::new), this.combine(queryFilter, pathFilter, header, body, requestFilter), this.combine(header, body, responseFilter), Optional.ofNullable(strategy).orElseGet(DefaultStrategy::new), Optional.ofNullable(sink).orElseGet(() -> new DefaultSink(new DefaultHttpLogFormatter(), new DefaultHttpLogWriter())));
    }

    @Nonnull
    private RequestFilter combine(@Nullable QueryFilter queryFilter, @Nullable PathFilter pathFilter, HeaderFilter headerFilter, BodyFilter bodyFilter, @Nullable RequestFilter requestFilter) {
        QueryFilter query = Optional.ofNullable(queryFilter).orElseGet(QueryFilters::defaultValue);
        PathFilter path = Optional.ofNullable(pathFilter).orElseGet(PathFilters::defaultValue);
        return RequestFilter.merge((RequestFilter)Optional.ofNullable(requestFilter).orElseGet(RequestFilters::defaultValue), request -> new FilteredHttpRequest(request, query, path, headerFilter, bodyFilter));
    }

    @Nonnull
    private ResponseFilter combine(HeaderFilter headerFilter, BodyFilter bodyFilter, @Nullable ResponseFilter responseFilter) {
        return ResponseFilter.merge((ResponseFilter)Optional.ofNullable(responseFilter).orElseGet(ResponseFilters::defaultValue), response -> new FilteredHttpResponse(response, headerFilter, bodyFilter));
    }
}

