/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zhtml;

import java.io.IOException;
import java.io.Writer;
import org.zkoss.lang.Objects;
import org.zkoss.xml.XMLs;
import org.zkoss.zhtml.impl.PageRenderer;
import org.zkoss.zhtml.impl.TagRenderContext;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.ext.RawId;
import org.zkoss.zk.ui.ext.render.DirectContent;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.HtmlPageRenders;

public class Text
extends AbstractComponent
implements RawId {
    private String _value = "";
    private boolean _encode = true;

    public Text() {
    }

    public Text(String value) {
        this.setValue(value);
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            if (this.isIdRequired()) {
                this.smartUpdate("value", this._value);
            } else {
                this.invalidate();
            }
        }
    }

    private boolean isIdRequired() {
        Component p = this.getParent();
        return p == null || !this.isVisible() || this.getId().length() > 0 || !Text.isRawLabel(p);
    }

    private static boolean isRawLabel(Component comp) {
        LanguageDefinition langdef = comp.getDefinition().getLanguageDefinition();
        return langdef != null && langdef.isRawLabel();
    }

    public boolean isEncode() {
        return this._encode;
    }

    public void setEncode(boolean encode) {
        this._encode = encode;
    }

    public String getWidgetClass() {
        return "zhtml.Text";
    }

    public void setParent(Component parent) {
        Component old = this.getParent();
        if (old != null && old != parent && !this.isIdRequired()) {
            old.invalidate();
        }
        super.setParent(parent);
        if (parent != null && old != parent && !this.isIdRequired()) {
            parent.invalidate();
        }
    }

    public void invalidate() {
        if (this.isIdRequired()) {
            super.invalidate();
        } else {
            this.getParent().invalidate();
        }
    }

    public void redraw(Writer out) throws IOException {
        TagRenderContext rc;
        Execution exec = Executions.getCurrent();
        if (!HtmlPageRenders.isDirectContent((Execution)exec)) {
            super.redraw(out);
            return;
        }
        boolean idRequired = this.isIdRequired();
        if (idRequired) {
            out.write("<span id=\"");
            out.write(this.getUuid());
            out.write("\">");
        }
        out.write(this._encode ? XMLs.encodeText((String)this._value) : this._value);
        if (idRequired) {
            out.write("</span>");
        }
        if ((rc = PageRenderer.getTagRenderContext(exec)) != null) {
            rc.renderBegin((Component)this, this.getClientEvents(), false);
            rc.renderEnd((Component)this);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "value", this._value);
        this.render(renderer, "idRequired", this.isIdRequired());
        if (!this._encode) {
            renderer.render("encode", false);
        }
    }

    protected boolean isChildable() {
        return false;
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    implements DirectContent {
        protected ExtraCtrl() {
        }
    }
}

