/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.jgit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jetbrains.annotations.NotNull;
import org.joda.time.ReadableInstant;
import pl.project13.jgit.dummy.DatedRevTag;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.util.Pair;

public class JGitCommon {
    private final LoggerBridge log;

    public JGitCommon(LoggerBridge log) {
        this.log = log;
    }

    /*
     * Exception decompiling
     */
    public Collection<String> getTags(Repository repo, ObjectId objectId) throws GitAPIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Collection<String> getTags(Git git, final ObjectId objectId, final RevWalk finalWalk) throws GitAPIException {
        List tagRefs = git.tagList().call();
        Collection tagsForHeadCommit = Collections2.filter((Collection)tagRefs, (Predicate)new Predicate<Ref>(){

            public boolean apply(Ref tagRef) {
                try {
                    RevCommit tagCommit = finalWalk.parseCommit((AnyObjectId)tagRef.getObjectId());
                    RevCommit objectCommit = finalWalk.parseCommit((AnyObjectId)objectId);
                    if (finalWalk.isMergedInto(objectCommit, tagCommit)) {
                        return true;
                    }
                }
                catch (Exception ignored) {
                    JGitCommon.this.log.debug("Failed while getTags [{}] -- ", (Object)tagRef, (Object)ignored);
                }
                return false;
            }
        });
        Collection tags = Collections2.transform((Collection)tagsForHeadCommit, (Function)new Function<Ref, String>(){

            public String apply(Ref input) {
                return input.getName().replaceAll("refs/tags/", "");
            }
        });
        return tags;
    }

    public String getClosestTagName(@NotNull String evaluateOnCommit, @NotNull Repository repo, GitDescribeConfig gitDescribe) {
        RevCommit headCommit = this.findEvalCommitObjectId(evaluateOnCommit, repo);
        Pair<RevCommit, String> pair = this.getClosestRevCommit(repo, headCommit, gitDescribe);
        return (String)pair.second;
    }

    public String getClosestTagCommitCount(@NotNull String evaluateOnCommit, @NotNull Repository repo, GitDescribeConfig gitDescribe) {
        RevCommit headCommit = this.findEvalCommitObjectId(evaluateOnCommit, repo);
        Pair<RevCommit, String> pair = this.getClosestRevCommit(repo, headCommit, gitDescribe);
        RevCommit revCommit = (RevCommit)pair.first;
        int distance = this.distanceBetween(repo, headCommit, revCommit);
        return String.valueOf(distance);
    }

    private Pair<RevCommit, String> getClosestRevCommit(@NotNull Repository repo, RevCommit headCommit, GitDescribeConfig gitDescribe) {
        Map<ObjectId, List<String>> tagObjectIdToName;
        boolean includeLightweightTags = false;
        String matchPattern = ".*";
        if (gitDescribe != null) {
            includeLightweightTags = gitDescribe.getTags();
            if (!"*".equals(gitDescribe.getMatch())) {
                matchPattern = this.createMatchPattern(gitDescribe.getMatch());
            }
        }
        if ((tagObjectIdToName = this.findTagObjectIds(repo, includeLightweightTags, matchPattern)).containsKey(headCommit)) {
            String tagName = tagObjectIdToName.get(headCommit).iterator().next();
            return Pair.of(headCommit, tagName);
        }
        List<RevCommit> commits = this.findCommitsUntilSomeTag(repo, headCommit, tagObjectIdToName);
        RevCommit revCommit = commits.get(0);
        String tagName = tagObjectIdToName.get(revCommit).iterator().next();
        return Pair.of(revCommit, tagName);
    }

    protected String createMatchPattern(String pattern) {
        return "^refs/tags/\\Q" + pattern.replace("*", "\\E.*\\Q").replace("?", "\\E.\\Q") + "\\E$";
    }

    protected Map<ObjectId, List<String>> findTagObjectIds(@NotNull Repository repo, boolean includeLightweightTags, String matchPattern) {
        Map<ObjectId, List<DatedRevTag>> commitIdsToTags = this.getCommitIdsToTags(repo, includeLightweightTags, matchPattern);
        HashMap<ObjectId, List<String>> commitIdsToTagNames = this.transformRevTagsMapToDateSortedTagNames(commitIdsToTags);
        this.log.info("Created map: [{}]", (Object)commitIdsToTagNames);
        return commitIdsToTagNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RevCommit findEvalCommitObjectId(@NotNull String evaluateOnCommit, @NotNull Repository repo) throws RuntimeException {
        try {
            ObjectId evalCommitId = repo.resolve(evaluateOnCommit);
            try (RevWalk walk = new RevWalk(repo);){
                RevCommit evalCommit = walk.parseCommit((AnyObjectId)evalCommitId);
                walk.dispose();
                this.log.info("evalCommit is [{}]", (Object)evalCommit.getName());
                RevCommit revCommit = evalCommit;
                return revCommit;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to obtain " + evaluateOnCommit + " commit!", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<ObjectId, List<DatedRevTag>> getCommitIdsToTags(@NotNull Repository repo, boolean includeLightweightTags, String matchPattern) {
        HashMap<ObjectId, ArrayList<DatedRevTag>> commitIdsToTags = new HashMap<ObjectId, ArrayList<DatedRevTag>>();
        try (RevWalk walk = new RevWalk(repo);){
            walk.markStart(walk.parseCommit((AnyObjectId)repo.resolve("HEAD")));
            List tagRefs = Git.wrap((Repository)repo).tagList().call();
            Pattern regex = Pattern.compile(matchPattern);
            this.log.info("Tag refs [{}]", (Object)tagRefs);
            for (Ref ref : tagRefs) {
                walk.reset();
                String name = ref.getName();
                if (!regex.matcher(name).matches()) {
                    this.log.info("Skipping tagRef with name [{}] as it doesn't match [{}]", (Object)name, (Object)matchPattern);
                    continue;
                }
                ObjectId resolvedCommitId = repo.resolve(name);
                try {
                    RevTag revTag = walk.parseTag((AnyObjectId)resolvedCommitId);
                    ObjectId taggedCommitId = revTag.getObject().getId();
                    this.log.info("Resolved tag [{}] [{}], points at [{}] ", revTag.getTagName(), revTag.getTaggerIdent(), taggedCommitId);
                    while (this.isTagId(taggedCommitId)) {
                        taggedCommitId = walk.parseTag((AnyObjectId)taggedCommitId).getObject().getId();
                    }
                    if (commitIdsToTags.containsKey(taggedCommitId)) {
                        ((List)commitIdsToTags.get(taggedCommitId)).add(new DatedRevTag(revTag));
                        continue;
                    }
                    commitIdsToTags.put(taggedCommitId, new ArrayList<DatedRevTag>(Collections.singletonList(new DatedRevTag(revTag))));
                }
                catch (IncorrectObjectTypeException ex) {
                    if (!includeLightweightTags) continue;
                    this.log.info("Including lightweight tag [{}]", (Object)name);
                    DatedRevTag datedRevTag = new DatedRevTag((AnyObjectId)resolvedCommitId, name);
                    if (commitIdsToTags.containsKey(resolvedCommitId)) {
                        ((List)commitIdsToTags.get(resolvedCommitId)).add(datedRevTag);
                        continue;
                    }
                    commitIdsToTags.put(resolvedCommitId, new ArrayList<DatedRevTag>(Collections.singletonList(datedRevTag)));
                }
                catch (Exception ignored) {
                    this.log.info("Failed while parsing [{}] -- ", (Object)ref, (Object)ignored);
                }
            }
            for (Map.Entry entry : commitIdsToTags.entrySet()) {
                this.log.info("key [{}], tags => [{}] ", entry.getKey(), entry.getValue());
            }
            HashMap<ObjectId, ArrayList<DatedRevTag>> hashMap = commitIdsToTags;
            return hashMap;
        }
        catch (Exception e) {
            this.log.info("Unable to locate tags", e);
            return Collections.emptyMap();
        }
    }

    private boolean isTagId(ObjectId objectId) {
        return objectId.toString().startsWith("tag ");
    }

    protected HashMap<ObjectId, List<String>> transformRevTagsMapToDateSortedTagNames(Map<ObjectId, List<DatedRevTag>> commitIdsToTags) {
        HashMap<ObjectId, List<String>> commitIdsToTagNames = new HashMap<ObjectId, List<String>>();
        for (Map.Entry<ObjectId, List<DatedRevTag>> objectIdListEntry : commitIdsToTags.entrySet()) {
            List<String> tagNames = this.transformRevTagsMapEntryToDateSortedTagNames(objectIdListEntry);
            commitIdsToTagNames.put(objectIdListEntry.getKey(), tagNames);
        }
        return commitIdsToTagNames;
    }

    private List<String> transformRevTagsMapEntryToDateSortedTagNames(Map.Entry<ObjectId, List<DatedRevTag>> objectIdListEntry) {
        List<DatedRevTag> tags = objectIdListEntry.getValue();
        ArrayList<DatedRevTag> newTags = new ArrayList<DatedRevTag>(tags);
        Collections.sort(newTags, this.datedRevTagComparator());
        List tagNames = Lists.transform(newTags, (Function)new Function<DatedRevTag, String>(){

            public String apply(DatedRevTag input) {
                return JGitCommon.this.trimFullTagName(input.tagName);
            }
        });
        return tagNames;
    }

    private Comparator<DatedRevTag> datedRevTagComparator() {
        return new Comparator<DatedRevTag>(){

            @Override
            public int compare(DatedRevTag revTag, DatedRevTag revTag2) {
                return revTag2.date.compareTo((ReadableInstant)revTag.date);
            }
        };
    }

    @VisibleForTesting
    protected String trimFullTagName(@NotNull String tagName) {
        return tagName.replaceFirst("refs/tags/", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<RevCommit> findCommitsUntilSomeTag(Repository repo, RevCommit head, @NotNull Map<ObjectId, List<String>> tagObjectIdToName) {
        try (RevWalk revWalk = new RevWalk(repo);){
            revWalk.markStart(head);
            for (RevCommit commit : revWalk) {
                List<String> maybeList;
                ObjectId objId = commit.getId();
                if (tagObjectIdToName.size() <= 0 || (maybeList = tagObjectIdToName.get(objId)) == null || maybeList.get(0) == null) continue;
                List<RevCommit> list = Collections.singletonList(commit);
                return list;
            }
            List list = Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find commits until some tag", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int distanceBetween(@NotNull Repository repo, @NotNull RevCommit child, @NotNull RevCommit parent) {
        try (RevWalk revWalk = new RevWalk(repo);){
            revWalk.markStart(child);
            HashSet<ObjectId> seena = new HashSet<ObjectId>();
            HashSet<ObjectId> seenb = new HashSet<ObjectId>();
            ArrayDeque<RevCommit> q = new ArrayDeque<RevCommit>();
            q.add(revWalk.parseCommit((AnyObjectId)child));
            int distance = 0;
            ObjectId parentId = parent.getId();
            while (q.size() > 0) {
                RevCommit commit = (RevCommit)q.remove();
                ObjectId commitId = commit.getId();
                if (seena.contains(commitId)) continue;
                seena.add(commitId);
                if (parentId.equals((AnyObjectId)commitId)) {
                    this.seeAllParents(revWalk, commit, seenb);
                    for (ObjectId oid : seenb) {
                        if (!seena.contains(oid)) continue;
                        --distance;
                    }
                    seena.addAll(seenb);
                    continue;
                }
                for (RevCommit oid : commit.getParents()) {
                    if (seena.contains(oid)) continue;
                    q.add(revWalk.parseCommit((AnyObjectId)oid));
                }
                ++distance;
            }
            int n = distance;
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to calculate distance between [%s] and [%s]", child, parent), e);
        }
    }

    private void seeAllParents(@NotNull RevWalk revWalk, RevCommit child, @NotNull Set<ObjectId> seen) throws IOException {
        ArrayDeque<RevCommit> q = new ArrayDeque<RevCommit>();
        q.add(child);
        while (q.size() > 0) {
            RevCommit commit = (RevCommit)q.remove();
            for (RevCommit oid : commit.getParents()) {
                if (seen.contains(oid)) continue;
                seen.add((ObjectId)oid);
                q.add(revWalk.parseCommit((AnyObjectId)oid));
            }
        }
    }

    public static boolean isRepositoryInDirtyState(Repository repo) throws GitAPIException {
        Git git = Git.wrap((Repository)repo);
        Status status = git.status().call();
        boolean isDirty = !status.getAdded().isEmpty() || !status.getChanged().isEmpty() || !status.getRemoved().isEmpty() || !status.getMissing().isEmpty() || !status.getModified().isEmpty() || !status.getConflicting().isEmpty();
        return isDirty;
    }
}

