/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.CloudTrailProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeneratedPolicyProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeneratedPolicyProperties> {
    private static final SdkField<CloudTrailProperties> CLOUD_TRAIL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudTrailProperties").getter(GeneratedPolicyProperties.getter(GeneratedPolicyProperties::cloudTrailProperties)).setter(GeneratedPolicyProperties.setter(Builder::cloudTrailProperties)).constructor(CloudTrailProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudTrailProperties").build()}).build();
    private static final SdkField<Boolean> IS_COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isComplete").getter(GeneratedPolicyProperties.getter(GeneratedPolicyProperties::isComplete)).setter(GeneratedPolicyProperties.setter(Builder::isComplete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isComplete").build()}).build();
    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalArn").getter(GeneratedPolicyProperties.getter(GeneratedPolicyProperties::principalArn)).setter(GeneratedPolicyProperties.setter(Builder::principalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_TRAIL_PROPERTIES_FIELD, IS_COMPLETE_FIELD, PRINCIPAL_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final CloudTrailProperties cloudTrailProperties;
    private final Boolean isComplete;
    private final String principalArn;

    private GeneratedPolicyProperties(BuilderImpl builder) {
        this.cloudTrailProperties = builder.cloudTrailProperties;
        this.isComplete = builder.isComplete;
        this.principalArn = builder.principalArn;
    }

    public final CloudTrailProperties cloudTrailProperties() {
        return this.cloudTrailProperties;
    }

    public final Boolean isComplete() {
        return this.isComplete;
    }

    public final String principalArn() {
        return this.principalArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudTrailProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.isComplete());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratedPolicyProperties)) {
            return false;
        }
        GeneratedPolicyProperties other = (GeneratedPolicyProperties)obj;
        return Objects.equals(this.cloudTrailProperties(), other.cloudTrailProperties()) && Objects.equals(this.isComplete(), other.isComplete()) && Objects.equals(this.principalArn(), other.principalArn());
    }

    public final String toString() {
        return ToString.builder((String)"GeneratedPolicyProperties").add("CloudTrailProperties", (Object)this.cloudTrailProperties()).add("IsComplete", (Object)this.isComplete()).add("PrincipalArn", (Object)this.principalArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudTrailProperties": {
                return Optional.ofNullable(clazz.cast(this.cloudTrailProperties()));
            }
            case "isComplete": {
                return Optional.ofNullable(clazz.cast(this.isComplete()));
            }
            case "principalArn": {
                return Optional.ofNullable(clazz.cast(this.principalArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeneratedPolicyProperties, T> g) {
        return obj -> g.apply((GeneratedPolicyProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudTrailProperties cloudTrailProperties;
        private Boolean isComplete;
        private String principalArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratedPolicyProperties model) {
            this.cloudTrailProperties(model.cloudTrailProperties);
            this.isComplete(model.isComplete);
            this.principalArn(model.principalArn);
        }

        public final CloudTrailProperties.Builder getCloudTrailProperties() {
            return this.cloudTrailProperties != null ? this.cloudTrailProperties.toBuilder() : null;
        }

        public final void setCloudTrailProperties(CloudTrailProperties.BuilderImpl cloudTrailProperties) {
            this.cloudTrailProperties = cloudTrailProperties != null ? cloudTrailProperties.build() : null;
        }

        @Override
        public final Builder cloudTrailProperties(CloudTrailProperties cloudTrailProperties) {
            this.cloudTrailProperties = cloudTrailProperties;
            return this;
        }

        public final Boolean getIsComplete() {
            return this.isComplete;
        }

        public final void setIsComplete(Boolean isComplete) {
            this.isComplete = isComplete;
        }

        @Override
        public final Builder isComplete(Boolean isComplete) {
            this.isComplete = isComplete;
            return this;
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public GeneratedPolicyProperties build() {
            return new GeneratedPolicyProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeneratedPolicyProperties> {
        public Builder cloudTrailProperties(CloudTrailProperties var1);

        default public Builder cloudTrailProperties(Consumer<CloudTrailProperties.Builder> cloudTrailProperties) {
            return this.cloudTrailProperties((CloudTrailProperties)((CloudTrailProperties.Builder)CloudTrailProperties.builder().applyMutation(cloudTrailProperties)).build());
        }

        public Builder isComplete(Boolean var1);

        public Builder principalArn(String var1);
    }
}

