/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appflow.model.AppflowResponse;
import software.amazon.awssdk.services.appflow.model.ConnectorEntity;
import software.amazon.awssdk.services.appflow.model.ConnectorEntityMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConnectorEntitiesResponse
extends AppflowResponse
implements ToCopyableBuilder<Builder, ListConnectorEntitiesResponse> {
    private static final SdkField<Map<String, List<ConnectorEntity>>> CONNECTOR_ENTITY_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("connectorEntityMap").getter(ListConnectorEntitiesResponse.getter(ListConnectorEntitiesResponse::connectorEntityMap)).setter(ListConnectorEntitiesResponse.setter(Builder::connectorEntityMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorEntityMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectorEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ENTITY_MAP_FIELD));
    private final Map<String, List<ConnectorEntity>> connectorEntityMap;

    private ListConnectorEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.connectorEntityMap = builder.connectorEntityMap;
    }

    public final boolean hasConnectorEntityMap() {
        return this.connectorEntityMap != null && !(this.connectorEntityMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<ConnectorEntity>> connectorEntityMap() {
        return this.connectorEntityMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorEntityMap() ? this.connectorEntityMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectorEntitiesResponse)) {
            return false;
        }
        ListConnectorEntitiesResponse other = (ListConnectorEntitiesResponse)((Object)obj);
        return this.hasConnectorEntityMap() == other.hasConnectorEntityMap() && Objects.equals(this.connectorEntityMap(), other.connectorEntityMap());
    }

    public final String toString() {
        return ToString.builder((String)"ListConnectorEntitiesResponse").add("ConnectorEntityMap", this.hasConnectorEntityMap() ? this.connectorEntityMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorEntityMap": {
                return Optional.ofNullable(clazz.cast(this.connectorEntityMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConnectorEntitiesResponse, T> g) {
        return obj -> g.apply((ListConnectorEntitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowResponse.BuilderImpl
    implements Builder {
        private Map<String, List<ConnectorEntity>> connectorEntityMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectorEntitiesResponse model) {
            super(model);
            this.connectorEntityMap(model.connectorEntityMap);
        }

        public final Map<String, List<ConnectorEntity.Builder>> getConnectorEntityMap() {
            Map<String, List<ConnectorEntity.Builder>> result = ConnectorEntityMapCopier.copyToBuilder(this.connectorEntityMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConnectorEntityMap(Map<String, ? extends Collection<ConnectorEntity.BuilderImpl>> connectorEntityMap) {
            this.connectorEntityMap = ConnectorEntityMapCopier.copyFromBuilder(connectorEntityMap);
        }

        @Override
        public final Builder connectorEntityMap(Map<String, ? extends Collection<ConnectorEntity>> connectorEntityMap) {
            this.connectorEntityMap = ConnectorEntityMapCopier.copy(connectorEntityMap);
            return this;
        }

        @Override
        public ListConnectorEntitiesResponse build() {
            return new ListConnectorEntitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppflowResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConnectorEntitiesResponse> {
        public Builder connectorEntityMap(Map<String, ? extends Collection<ConnectorEntity>> var1);
    }
}

