/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SAPODataSourceProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SAPODataSourceProperties> {
    private static final SdkField<String> OBJECT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("objectPath").getter(SAPODataSourceProperties.getter(SAPODataSourceProperties::objectPath)).setter(SAPODataSourceProperties.setter(Builder::objectPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String objectPath;

    private SAPODataSourceProperties(BuilderImpl builder) {
        this.objectPath = builder.objectPath;
    }

    public final String objectPath() {
        return this.objectPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAPODataSourceProperties)) {
            return false;
        }
        SAPODataSourceProperties other = (SAPODataSourceProperties)obj;
        return Objects.equals(this.objectPath(), other.objectPath());
    }

    public final String toString() {
        return ToString.builder((String)"SAPODataSourceProperties").add("ObjectPath", (Object)this.objectPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "objectPath": {
                return Optional.ofNullable(clazz.cast(this.objectPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SAPODataSourceProperties, T> g) {
        return obj -> g.apply((SAPODataSourceProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String objectPath;

        private BuilderImpl() {
        }

        private BuilderImpl(SAPODataSourceProperties model) {
            this.objectPath(model.objectPath);
        }

        public final String getObjectPath() {
            return this.objectPath;
        }

        public final void setObjectPath(String objectPath) {
            this.objectPath = objectPath;
        }

        @Override
        public final Builder objectPath(String objectPath) {
            this.objectPath = objectPath;
            return this;
        }

        public SAPODataSourceProperties build() {
            return new SAPODataSourceProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SAPODataSourceProperties> {
        public Builder objectPath(String var1);
    }
}

