/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterValue> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ParameterValue.getter(ParameterValue::id)).setter(ParameterValue.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(ParameterValue.getter(ParameterValue::stringValue)).setter(ParameterValue.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STRING_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String stringValue;

    private ParameterValue(BuilderImpl builder) {
        this.id = builder.id;
        this.stringValue = builder.stringValue;
    }

    public final String id() {
        return this.id;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterValue)) {
            return false;
        }
        ParameterValue other = (ParameterValue)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.stringValue(), other.stringValue());
    }

    public final String toString() {
        return ToString.builder((String)"ParameterValue").add("Id", (Object)this.id()).add("StringValue", (Object)this.stringValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterValue, T> g) {
        return obj -> g.apply((ParameterValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String stringValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterValue model) {
            this.id(model.id);
            this.stringValue(model.stringValue);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public ParameterValue build() {
            return new ParameterValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterValue> {
        public Builder id(String var1);

        public Builder stringValue(String var1);
    }
}

