/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.InstanceIdentity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PollForTaskRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, PollForTaskRequest> {
    private static final SdkField<String> WORKER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workerGroup").getter(PollForTaskRequest.getter(PollForTaskRequest::workerGroup)).setter(PollForTaskRequest.setter(Builder::workerGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerGroup").build()}).build();
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostname").getter(PollForTaskRequest.getter(PollForTaskRequest::hostname)).setter(PollForTaskRequest.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<InstanceIdentity> INSTANCE_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instanceIdentity").getter(PollForTaskRequest.getter(PollForTaskRequest::instanceIdentity)).setter(PollForTaskRequest.setter(Builder::instanceIdentity)).constructor(InstanceIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceIdentity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKER_GROUP_FIELD, HOSTNAME_FIELD, INSTANCE_IDENTITY_FIELD));
    private final String workerGroup;
    private final String hostname;
    private final InstanceIdentity instanceIdentity;

    private PollForTaskRequest(BuilderImpl builder) {
        super(builder);
        this.workerGroup = builder.workerGroup;
        this.hostname = builder.hostname;
        this.instanceIdentity = builder.instanceIdentity;
    }

    public final String workerGroup() {
        return this.workerGroup;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final InstanceIdentity instanceIdentity() {
        return this.instanceIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workerGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIdentity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForTaskRequest)) {
            return false;
        }
        PollForTaskRequest other = (PollForTaskRequest)((Object)obj);
        return Objects.equals(this.workerGroup(), other.workerGroup()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.instanceIdentity(), other.instanceIdentity());
    }

    public final String toString() {
        return ToString.builder((String)"PollForTaskRequest").add("WorkerGroup", (Object)this.workerGroup()).add("Hostname", (Object)this.hostname()).add("InstanceIdentity", (Object)this.instanceIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workerGroup": {
                return Optional.ofNullable(clazz.cast(this.workerGroup()));
            }
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "instanceIdentity": {
                return Optional.ofNullable(clazz.cast(this.instanceIdentity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PollForTaskRequest, T> g) {
        return obj -> g.apply((PollForTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String workerGroup;
        private String hostname;
        private InstanceIdentity instanceIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForTaskRequest model) {
            super(model);
            this.workerGroup(model.workerGroup);
            this.hostname(model.hostname);
            this.instanceIdentity(model.instanceIdentity);
        }

        public final String getWorkerGroup() {
            return this.workerGroup;
        }

        public final void setWorkerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
        }

        @Override
        public final Builder workerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
            return this;
        }

        public final String getHostname() {
            return this.hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final InstanceIdentity.Builder getInstanceIdentity() {
            return this.instanceIdentity != null ? this.instanceIdentity.toBuilder() : null;
        }

        public final void setInstanceIdentity(InstanceIdentity.BuilderImpl instanceIdentity) {
            this.instanceIdentity = instanceIdentity != null ? instanceIdentity.build() : null;
        }

        @Override
        public final Builder instanceIdentity(InstanceIdentity instanceIdentity) {
            this.instanceIdentity = instanceIdentity;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PollForTaskRequest build() {
            return new PollForTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PollForTaskRequest> {
        public Builder workerGroup(String var1);

        public Builder hostname(String var1);

        public Builder instanceIdentity(InstanceIdentity var1);

        default public Builder instanceIdentity(Consumer<InstanceIdentity.Builder> instanceIdentity) {
            return this.instanceIdentity((InstanceIdentity)((InstanceIdentity.Builder)InstanceIdentity.builder().applyMutation(instanceIdentity)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

