/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamesparks.model.GameSparksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStageRequest
extends GameSparksRequest
implements ToCopyableBuilder<Builder, UpdateStageRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateStageRequest.getter(UpdateStageRequest::description)).setter(UpdateStageRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> GAME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameName").getter(UpdateStageRequest.getter(UpdateStageRequest::gameName)).setter(UpdateStageRequest.setter(Builder::gameName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("GameName").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(UpdateStageRequest.getter(UpdateStageRequest::role)).setter(UpdateStageRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageName").getter(UpdateStageRequest.getter(UpdateStageRequest::stageName)).setter(UpdateStageRequest.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("StageName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, GAME_NAME_FIELD, ROLE_FIELD, STAGE_NAME_FIELD));
    private final String description;
    private final String gameName;
    private final String role;
    private final String stageName;

    private UpdateStageRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.gameName = builder.gameName;
        this.role = builder.role;
        this.stageName = builder.stageName;
    }

    public final String description() {
        return this.description;
    }

    public final String gameName() {
        return this.gameName;
    }

    public final String role() {
        return this.role;
    }

    public final String stageName() {
        return this.stageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameName());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStageRequest)) {
            return false;
        }
        UpdateStageRequest other = (UpdateStageRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.gameName(), other.gameName()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.stageName(), other.stageName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStageRequest").add("Description", (Object)this.description()).add("GameName", (Object)this.gameName()).add("Role", (Object)this.role()).add("StageName", (Object)this.stageName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "GameName": {
                return Optional.ofNullable(clazz.cast(this.gameName()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "StageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStageRequest, T> g) {
        return obj -> g.apply((UpdateStageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameSparksRequest.BuilderImpl
    implements Builder {
        private String description;
        private String gameName;
        private String role;
        private String stageName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStageRequest model) {
            super(model);
            this.description(model.description);
            this.gameName(model.gameName);
            this.role(model.role);
            this.stageName(model.stageName);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getGameName() {
            return this.gameName;
        }

        public final void setGameName(String gameName) {
            this.gameName = gameName;
        }

        @Override
        public final Builder gameName(String gameName) {
            this.gameName = gameName;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStageRequest build() {
            return new UpdateStageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameSparksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStageRequest> {
        public Builder description(String var1);

        public Builder gameName(String var1);

        public Builder role(String var1);

        public Builder stageName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

