/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickprojects.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot1clickprojects.Iot1ClickProjectsAsyncClient;
import software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.PlacementSummary;

public class ListPlacementsPublisher
implements SdkPublisher<ListPlacementsResponse> {
    private final Iot1ClickProjectsAsyncClient client;
    private final ListPlacementsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPlacementsPublisher(Iot1ClickProjectsAsyncClient client, ListPlacementsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPlacementsPublisher(Iot1ClickProjectsAsyncClient client, ListPlacementsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPlacementsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPlacementsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PlacementSummary> placements() {
        Function<ListPlacementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.placements() != null) {
                return response.placements().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPlacementsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPlacementsResponseFetcher
    implements AsyncPageFetcher<ListPlacementsResponse> {
        private ListPlacementsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlacementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPlacementsResponse> nextPage(ListPlacementsResponse previousPage) {
            if (previousPage == null) {
                return ListPlacementsPublisher.this.client.listPlacements(ListPlacementsPublisher.this.firstRequest);
            }
            return ListPlacementsPublisher.this.client.listPlacements((ListPlacementsRequest)((Object)ListPlacementsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

