/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingAsyncClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetMigrationsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetMigrationsResponse;

public class GetMigrationsPublisher
implements SdkPublisher<GetMigrationsResponse> {
    private final LexModelBuildingAsyncClient client;
    private final GetMigrationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetMigrationsPublisher(LexModelBuildingAsyncClient client, GetMigrationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetMigrationsPublisher(LexModelBuildingAsyncClient client, GetMigrationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetMigrationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetMigrationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetMigrationsResponseFetcher
    implements AsyncPageFetcher<GetMigrationsResponse> {
        private GetMigrationsResponseFetcher() {
        }

        public boolean hasNextPage(GetMigrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetMigrationsResponse> nextPage(GetMigrationsResponse previousPage) {
            if (previousPage == null) {
                return GetMigrationsPublisher.this.client.getMigrations(GetMigrationsPublisher.this.firstRequest);
            }
            return GetMigrationsPublisher.this.client.getMigrations((GetMigrationsRequest)((Object)GetMigrationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

