/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingAsyncClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsResponse;

public class GetSlotTypeVersionsPublisher
implements SdkPublisher<GetSlotTypeVersionsResponse> {
    private final LexModelBuildingAsyncClient client;
    private final GetSlotTypeVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSlotTypeVersionsPublisher(LexModelBuildingAsyncClient client, GetSlotTypeVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSlotTypeVersionsPublisher(LexModelBuildingAsyncClient client, GetSlotTypeVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSlotTypeVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSlotTypeVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetSlotTypeVersionsResponseFetcher
    implements AsyncPageFetcher<GetSlotTypeVersionsResponse> {
        private GetSlotTypeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetSlotTypeVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSlotTypeVersionsResponse> nextPage(GetSlotTypeVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetSlotTypeVersionsPublisher.this.client.getSlotTypeVersions(GetSlotTypeVersionsPublisher.this.firstRequest);
            }
            return GetSlotTypeVersionsPublisher.this.client.getSlotTypeVersions((GetSlotTypeVersionsRequest)((Object)GetSlotTypeVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

