/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.CookieObject;
import software.amazon.awssdk.services.lightsail.model.HeaderObject;
import software.amazon.awssdk.services.lightsail.model.QueryStringObject;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CacheSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CacheSettings> {
    private static final SdkField<Long> DEFAULT_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("defaultTTL").getter(CacheSettings.getter(CacheSettings::defaultTTL)).setter(CacheSettings.setter(Builder::defaultTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTTL").build()}).build();
    private static final SdkField<Long> MINIMUM_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("minimumTTL").getter(CacheSettings.getter(CacheSettings::minimumTTL)).setter(CacheSettings.setter(Builder::minimumTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumTTL").build()}).build();
    private static final SdkField<Long> MAXIMUM_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("maximumTTL").getter(CacheSettings.getter(CacheSettings::maximumTTL)).setter(CacheSettings.setter(Builder::maximumTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumTTL").build()}).build();
    private static final SdkField<String> ALLOWED_HTTP_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("allowedHTTPMethods").getter(CacheSettings.getter(CacheSettings::allowedHTTPMethods)).setter(CacheSettings.setter(Builder::allowedHTTPMethods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedHTTPMethods").build()}).build();
    private static final SdkField<String> CACHED_HTTP_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cachedHTTPMethods").getter(CacheSettings.getter(CacheSettings::cachedHTTPMethods)).setter(CacheSettings.setter(Builder::cachedHTTPMethods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachedHTTPMethods").build()}).build();
    private static final SdkField<CookieObject> FORWARDED_COOKIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("forwardedCookies").getter(CacheSettings.getter(CacheSettings::forwardedCookies)).setter(CacheSettings.setter(Builder::forwardedCookies)).constructor(CookieObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forwardedCookies").build()}).build();
    private static final SdkField<HeaderObject> FORWARDED_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("forwardedHeaders").getter(CacheSettings.getter(CacheSettings::forwardedHeaders)).setter(CacheSettings.setter(Builder::forwardedHeaders)).constructor(HeaderObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forwardedHeaders").build()}).build();
    private static final SdkField<QueryStringObject> FORWARDED_QUERY_STRINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("forwardedQueryStrings").getter(CacheSettings.getter(CacheSettings::forwardedQueryStrings)).setter(CacheSettings.setter(Builder::forwardedQueryStrings)).constructor(QueryStringObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forwardedQueryStrings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_TTL_FIELD, MINIMUM_TTL_FIELD, MAXIMUM_TTL_FIELD, ALLOWED_HTTP_METHODS_FIELD, CACHED_HTTP_METHODS_FIELD, FORWARDED_COOKIES_FIELD, FORWARDED_HEADERS_FIELD, FORWARDED_QUERY_STRINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long defaultTTL;
    private final Long minimumTTL;
    private final Long maximumTTL;
    private final String allowedHTTPMethods;
    private final String cachedHTTPMethods;
    private final CookieObject forwardedCookies;
    private final HeaderObject forwardedHeaders;
    private final QueryStringObject forwardedQueryStrings;

    private CacheSettings(BuilderImpl builder) {
        this.defaultTTL = builder.defaultTTL;
        this.minimumTTL = builder.minimumTTL;
        this.maximumTTL = builder.maximumTTL;
        this.allowedHTTPMethods = builder.allowedHTTPMethods;
        this.cachedHTTPMethods = builder.cachedHTTPMethods;
        this.forwardedCookies = builder.forwardedCookies;
        this.forwardedHeaders = builder.forwardedHeaders;
        this.forwardedQueryStrings = builder.forwardedQueryStrings;
    }

    public final Long defaultTTL() {
        return this.defaultTTL;
    }

    public final Long minimumTTL() {
        return this.minimumTTL;
    }

    public final Long maximumTTL() {
        return this.maximumTTL;
    }

    public final String allowedHTTPMethods() {
        return this.allowedHTTPMethods;
    }

    public final String cachedHTTPMethods() {
        return this.cachedHTTPMethods;
    }

    public final CookieObject forwardedCookies() {
        return this.forwardedCookies;
    }

    public final HeaderObject forwardedHeaders() {
        return this.forwardedHeaders;
    }

    public final QueryStringObject forwardedQueryStrings() {
        return this.forwardedQueryStrings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedHTTPMethods());
        hashCode = 31 * hashCode + Objects.hashCode(this.cachedHTTPMethods());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardedCookies());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardedHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardedQueryStrings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheSettings)) {
            return false;
        }
        CacheSettings other = (CacheSettings)obj;
        return Objects.equals(this.defaultTTL(), other.defaultTTL()) && Objects.equals(this.minimumTTL(), other.minimumTTL()) && Objects.equals(this.maximumTTL(), other.maximumTTL()) && Objects.equals(this.allowedHTTPMethods(), other.allowedHTTPMethods()) && Objects.equals(this.cachedHTTPMethods(), other.cachedHTTPMethods()) && Objects.equals(this.forwardedCookies(), other.forwardedCookies()) && Objects.equals(this.forwardedHeaders(), other.forwardedHeaders()) && Objects.equals(this.forwardedQueryStrings(), other.forwardedQueryStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CacheSettings").add("DefaultTTL", (Object)this.defaultTTL()).add("MinimumTTL", (Object)this.minimumTTL()).add("MaximumTTL", (Object)this.maximumTTL()).add("AllowedHTTPMethods", (Object)this.allowedHTTPMethods()).add("CachedHTTPMethods", (Object)this.cachedHTTPMethods()).add("ForwardedCookies", (Object)this.forwardedCookies()).add("ForwardedHeaders", (Object)this.forwardedHeaders()).add("ForwardedQueryStrings", (Object)this.forwardedQueryStrings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultTTL": {
                return Optional.ofNullable(clazz.cast(this.defaultTTL()));
            }
            case "minimumTTL": {
                return Optional.ofNullable(clazz.cast(this.minimumTTL()));
            }
            case "maximumTTL": {
                return Optional.ofNullable(clazz.cast(this.maximumTTL()));
            }
            case "allowedHTTPMethods": {
                return Optional.ofNullable(clazz.cast(this.allowedHTTPMethods()));
            }
            case "cachedHTTPMethods": {
                return Optional.ofNullable(clazz.cast(this.cachedHTTPMethods()));
            }
            case "forwardedCookies": {
                return Optional.ofNullable(clazz.cast(this.forwardedCookies()));
            }
            case "forwardedHeaders": {
                return Optional.ofNullable(clazz.cast(this.forwardedHeaders()));
            }
            case "forwardedQueryStrings": {
                return Optional.ofNullable(clazz.cast(this.forwardedQueryStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CacheSettings, T> g) {
        return obj -> g.apply((CacheSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long defaultTTL;
        private Long minimumTTL;
        private Long maximumTTL;
        private String allowedHTTPMethods;
        private String cachedHTTPMethods;
        private CookieObject forwardedCookies;
        private HeaderObject forwardedHeaders;
        private QueryStringObject forwardedQueryStrings;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheSettings model) {
            this.defaultTTL(model.defaultTTL);
            this.minimumTTL(model.minimumTTL);
            this.maximumTTL(model.maximumTTL);
            this.allowedHTTPMethods(model.allowedHTTPMethods);
            this.cachedHTTPMethods(model.cachedHTTPMethods);
            this.forwardedCookies(model.forwardedCookies);
            this.forwardedHeaders(model.forwardedHeaders);
            this.forwardedQueryStrings(model.forwardedQueryStrings);
        }

        public final Long getDefaultTTL() {
            return this.defaultTTL;
        }

        public final void setDefaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
        }

        @Override
        public final Builder defaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
            return this;
        }

        public final Long getMinimumTTL() {
            return this.minimumTTL;
        }

        public final void setMinimumTTL(Long minimumTTL) {
            this.minimumTTL = minimumTTL;
        }

        @Override
        public final Builder minimumTTL(Long minimumTTL) {
            this.minimumTTL = minimumTTL;
            return this;
        }

        public final Long getMaximumTTL() {
            return this.maximumTTL;
        }

        public final void setMaximumTTL(Long maximumTTL) {
            this.maximumTTL = maximumTTL;
        }

        @Override
        public final Builder maximumTTL(Long maximumTTL) {
            this.maximumTTL = maximumTTL;
            return this;
        }

        public final String getAllowedHTTPMethods() {
            return this.allowedHTTPMethods;
        }

        public final void setAllowedHTTPMethods(String allowedHTTPMethods) {
            this.allowedHTTPMethods = allowedHTTPMethods;
        }

        @Override
        public final Builder allowedHTTPMethods(String allowedHTTPMethods) {
            this.allowedHTTPMethods = allowedHTTPMethods;
            return this;
        }

        public final String getCachedHTTPMethods() {
            return this.cachedHTTPMethods;
        }

        public final void setCachedHTTPMethods(String cachedHTTPMethods) {
            this.cachedHTTPMethods = cachedHTTPMethods;
        }

        @Override
        public final Builder cachedHTTPMethods(String cachedHTTPMethods) {
            this.cachedHTTPMethods = cachedHTTPMethods;
            return this;
        }

        public final CookieObject.Builder getForwardedCookies() {
            return this.forwardedCookies != null ? this.forwardedCookies.toBuilder() : null;
        }

        public final void setForwardedCookies(CookieObject.BuilderImpl forwardedCookies) {
            this.forwardedCookies = forwardedCookies != null ? forwardedCookies.build() : null;
        }

        @Override
        public final Builder forwardedCookies(CookieObject forwardedCookies) {
            this.forwardedCookies = forwardedCookies;
            return this;
        }

        public final HeaderObject.Builder getForwardedHeaders() {
            return this.forwardedHeaders != null ? this.forwardedHeaders.toBuilder() : null;
        }

        public final void setForwardedHeaders(HeaderObject.BuilderImpl forwardedHeaders) {
            this.forwardedHeaders = forwardedHeaders != null ? forwardedHeaders.build() : null;
        }

        @Override
        public final Builder forwardedHeaders(HeaderObject forwardedHeaders) {
            this.forwardedHeaders = forwardedHeaders;
            return this;
        }

        public final QueryStringObject.Builder getForwardedQueryStrings() {
            return this.forwardedQueryStrings != null ? this.forwardedQueryStrings.toBuilder() : null;
        }

        public final void setForwardedQueryStrings(QueryStringObject.BuilderImpl forwardedQueryStrings) {
            this.forwardedQueryStrings = forwardedQueryStrings != null ? forwardedQueryStrings.build() : null;
        }

        @Override
        public final Builder forwardedQueryStrings(QueryStringObject forwardedQueryStrings) {
            this.forwardedQueryStrings = forwardedQueryStrings;
            return this;
        }

        public CacheSettings build() {
            return new CacheSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CacheSettings> {
        public Builder defaultTTL(Long var1);

        public Builder minimumTTL(Long var1);

        public Builder maximumTTL(Long var1);

        public Builder allowedHTTPMethods(String var1);

        public Builder cachedHTTPMethods(String var1);

        public Builder forwardedCookies(CookieObject var1);

        default public Builder forwardedCookies(Consumer<CookieObject.Builder> forwardedCookies) {
            return this.forwardedCookies((CookieObject)((CookieObject.Builder)CookieObject.builder().applyMutation(forwardedCookies)).build());
        }

        public Builder forwardedHeaders(HeaderObject var1);

        default public Builder forwardedHeaders(Consumer<HeaderObject.Builder> forwardedHeaders) {
            return this.forwardedHeaders((HeaderObject)((HeaderObject.Builder)HeaderObject.builder().applyMutation(forwardedHeaders)).build());
        }

        public Builder forwardedQueryStrings(QueryStringObject var1);

        default public Builder forwardedQueryStrings(Consumer<QueryStringObject.Builder> forwardedQueryStrings) {
            return this.forwardedQueryStrings((QueryStringObject)((QueryStringObject.Builder)QueryStringObject.builder().applyMutation(forwardedQueryStrings)).build());
        }
    }
}

