/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContainerServicePowerName {
    NANO("nano"),
    MICRO("micro"),
    SMALL("small"),
    MEDIUM("medium"),
    LARGE("large"),
    XLARGE("xlarge"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerServicePowerName> VALUE_MAP;
    private final String value;

    private ContainerServicePowerName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerServicePowerName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerServicePowerName> knownValues() {
        EnumSet<ContainerServicePowerName> knownValues = EnumSet.allOf(ContainerServicePowerName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContainerServicePowerName.class, ContainerServicePowerName::toString);
    }
}

