/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerServiceRegistryLogin
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerServiceRegistryLogin> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(ContainerServiceRegistryLogin.getter(ContainerServiceRegistryLogin::username)).setter(ContainerServiceRegistryLogin.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("password").getter(ContainerServiceRegistryLogin.getter(ContainerServiceRegistryLogin::password)).setter(ContainerServiceRegistryLogin.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("password").build()}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresAt").getter(ContainerServiceRegistryLogin.getter(ContainerServiceRegistryLogin::expiresAt)).setter(ContainerServiceRegistryLogin.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()}).build();
    private static final SdkField<String> REGISTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registry").getter(ContainerServiceRegistryLogin.getter(ContainerServiceRegistryLogin::registry)).setter(ContainerServiceRegistryLogin.setter(Builder::registry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, PASSWORD_FIELD, EXPIRES_AT_FIELD, REGISTRY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String username;
    private final String password;
    private final Instant expiresAt;
    private final String registry;

    private ContainerServiceRegistryLogin(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.expiresAt = builder.expiresAt;
        this.registry = builder.registry;
    }

    public final String username() {
        return this.username;
    }

    public final String password() {
        return this.password;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public final String registry() {
        return this.registry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.registry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerServiceRegistryLogin)) {
            return false;
        }
        ContainerServiceRegistryLogin other = (ContainerServiceRegistryLogin)obj;
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.expiresAt(), other.expiresAt()) && Objects.equals(this.registry(), other.registry());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerServiceRegistryLogin").add("Username", (Object)this.username()).add("Password", (Object)this.password()).add("ExpiresAt", (Object)this.expiresAt()).add("Registry", (Object)this.registry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "expiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
            case "registry": {
                return Optional.ofNullable(clazz.cast(this.registry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerServiceRegistryLogin, T> g) {
        return obj -> g.apply((ContainerServiceRegistryLogin)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String username;
        private String password;
        private Instant expiresAt;
        private String registry;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerServiceRegistryLogin model) {
            this.username(model.username);
            this.password(model.password);
            this.expiresAt(model.expiresAt);
            this.registry(model.registry);
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getRegistry() {
            return this.registry;
        }

        public final void setRegistry(String registry) {
            this.registry = registry;
        }

        @Override
        public final Builder registry(String registry) {
            this.registry = registry;
            return this;
        }

        public ContainerServiceRegistryLogin build() {
            return new ContainerServiceRegistryLogin(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerServiceRegistryLogin> {
        public Builder username(String var1);

        public Builder password(String var1);

        public Builder expiresAt(Instant var1);

        public Builder registry(String var1);
    }
}

